﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Admin_UpdateRole:System.Web.UI.Page
{
	int nRoleID = -1;
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(Request.Params["RoleID"] != null)
		{
			if(Int32.TryParse(Request.Params["RoleID"].ToString(),out nRoleID) == false)
			{
				return;
			}
		}
		if(!Page.IsPostBack)
		{
			if(nRoleID > -1)
			{
				BindRoleData(nRoleID);
			}
		}
		UpdateBtn.Enabled = btnSetAuth.Enabled = nRoleID > -1 ? true : false;
	}

	private void BindRoleData(int nRoleID)
	{
		IRole role = new Role();
		SqlDataReader dr = role.GetSingleRole(nRoleID);
		if(dr.Read())
		{
			Name.Text = dr["Name"].ToString();
		}
		dr.Close();
	}
	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{
			case "update":
				{
					UpdateRole();
					break;
				}
			case "set":
				{
					SetRoleAuthenticate();
					break;
				}
			case "return":
				{
					Response.Redirect("~/Admin/RoleManage.aspx");
					break;
				}
			default: break;
		}
	}
	private void UpdateRole()
	{
		IRole role = new Role();
		try
		{
			role.UpdateRole(nRoleID,Name.Text.Trim());
			Response.Write(SysOperation.OpenDialog(
					SysInfomation.UPDATE_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}
	private void SetRoleAuthenticate()
	{
		if(nRoleID > 0)
		{
			Response.Redirect("~/Admin/RoleAuthenticate.aspx?RoleID="
				+ nRoleID.ToString());
		}
	}
}
