﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Admin_UpdateUserRole:System.Web.UI.Page
{
	int nUserID = -1;
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(Request.Params["UserID"] != null)
		{
			if(Int32.TryParse(Request.Params["UserID"].ToString(),out nUserID) == false)
			{
				return;
			}
		}
		if(!Page.IsPostBack)
		{
			BindRoleData();
			if(nUserID > -1)
			{
				BindUserData(nUserID);
			}
		}
		btnSetAuth.Enabled = nUserID > -1 ? true : false;		
	}

	private void BindUserData(int nUserID)
	{
		IUser user = new User();
		SqlDataReader dr = user.GetSingleUser(nUserID);
		if(dr.Read())
		{
			lbName.Text = dr["UserName"].ToString();
		}
		dr.Close();
	}
	private void BindRoleData()
	{
		IRole role = new Role();
		SqlDataReader dr = role.GetRoles();

		RoleList.DataSource = dr;
		RoleList.DataTextField = "Name";
		RoleList.DataValueField = "ID";
		RoleList.DataBind();

		dr.Close();
	}

	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{			
			case "set":
				{
					if(RoleList.SelectedIndex <= -1)
					{
						Response.Write(SysOperation.OpenDialog(
							SysInfomation.SELECT_DATA_NO_ITEM));
						return;
					}
					SetUserRole();
					break;
				}
			case "return":
				{
					Response.Redirect("~/Admin/UserManage.aspx");				
					break;
				}
			default: break;
		}
	}

	private void SetUserRole()
	{
		IUser user = new User();

		try
		{
			user.UpdateUserRole(nUserID,Int32.Parse(RoleList.SelectedValue));
			Response.Write(SysOperation.OpenDialog(
						SysInfomation.UPDATE_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}
}
