﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Admin_UserManage : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");			
			return;
		}
		if(!Page.IsPostBack)
		{
			BindUserData();
		}
    }
	private void BindUserData()
	{
		IUser user = new User();
		DataSet ds = new DataSet("UserDataSet");
		user.GetUserDS(ref ds); ;

		UserView.DataSource = ds;
		UserView.DataBind();
	}
	protected void NewUserBtn_Click(object sender,EventArgs e)
	{
		Response.Redirect("~/Admin/AddUser.aspx");
	}
	protected void UserView_RowCommand(object sender,GridViewCommandEventArgs e)
	{
		IUser user = new User();
		try
		{
			user.DeleteUser(Int32.Parse(e.CommandArgument.ToString()));
			
			BindUserData();
			Response.Write(SysOperation.OpenDialog(
						SysInfomation.DELETE_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}
	protected void UserView_RowDeleting(object sender,GridViewDeleteEventArgs e)
	{
		///
	}
	protected void UserView_RowDataBound(object sender,GridViewRowEventArgs e)
	{
		ImageButton deleteBtn = (ImageButton)e.Row.FindControl("DeleteBtn");
		if(deleteBtn != null)
		{
			deleteBtn.Attributes.Add("onclick","return confirm('你确定要删除所选择的数据吗?');");
		}
	}
}
