﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SQLHelper;

public interface ICatalog
{
	void InitCatalogTree(TreeView tv);
	void BindCatalogTreeView(TreeView tv,bool isExpanded,string sSelectedData);
	SqlDataReader GetCatalogs();


	void GetCatalogDS(ref DataSet ds);

	SqlDataReader GetSingleCatalog(int nCatalogID);
	SqlDataReader GetSubCatalog(int nCatalogID);

	void GetSubCatalogDS(int nCatalogID,int nRowCount,ref DataSet ds);

	SqlDataReader GetAncestorCatalog(int nCatalogID);
	int AddCatalog(string sName,int nParentID);
	int UpdateCatalog(int nCatalogID,string sName);	
	int UpdateCatalogOrder(int nCatalogID,string sMoveFlag);
	int DeleteCatalog(int nCatalogID);
	int DeleteCatalogUrl(int nCatalogID);
}

public interface IUrl
{
	SqlDataReader GetUrlByCatalog(int nCatalogID);
	int AddUrl(int nCatalogID,string sUrl);
	int DeleteUrl(int nCatalogID);
}

/// <summary>
/// Catalog 的摘要说明
/// </summary>
public class Catalog:ICatalog
{
	public Catalog()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

	#region ICatalog 成员

	public void InitCatalogTree(TreeView tv)
	{
		DataTable dt = SystemTools.ConvertDataReaderToDataTable(
			GetCatalogs());
		
		tv.Nodes.Clear();     ///清空树的所有节点		
		DataRow[] rowList = dt.Select("ParentID='-1'");
		if(rowList.Length <= 1) return;

		///创建根节点
		TreeNode root = new TreeNode();
		///设置根节点属性
		root.Text = rowList[1]["Name"].ToString();
		///设置根节点的value值
		root.Value = rowList[1]["ID"].ToString();
		root.Target = "ContentDesktop";
		root.NavigateUrl = "~/Content/Admin/ContentManage.aspx?CatalogID="
			+ root.Value;
		root.Expanded = true;

		///添加根节点
		tv.Nodes.Add(root);

		///创建其他节点
		CreateChildNode(root,dt);
	}

	private void CreateChildNode(TreeNode parentNode,DataTable dt)
	{
		///选择数据时，添加了排序表达式OrderBy
		DataRow[] rowList = dt.Select("ParentID='" + parentNode.Value
			+ "'","OrderBy");
		foreach(DataRow row in rowList)
		{   ///创建新节点
			TreeNode node = new TreeNode();
			///设置节点的属性
			node.Text = row["Name"].ToString();
			node.Value = row["ID"].ToString();
			node.Target = "ContentDesktop";
			node.NavigateUrl = "~/Content/Admin/ContentManage.aspx?CatalogID="
				+ node.Value;
			parentNode.ChildNodes.Add(node);
			///递归调用，创建其他节点
			CreateChildNode(node,dt);
		}
	}

	public void BindCatalogTreeView(TreeView tv,bool isExpanded,string sSelectedData)
	{
		Catalog cata = new Catalog();
		DataTable dataTable = SystemTools.ConvertDataReaderToDataTable(cata.GetCatalogs());
		tv.Nodes.Clear();     ///清空树的所有节点

		DataRow[] rowList = dataTable.Select("ParentID='-1'");
		if(rowList.Length <= 1) return;

		///创建根节点
		TreeNode rootNode = new TreeNode();
		///设置根节点属性
		rootNode.Text = rowList[1]["Name"].ToString();
		rootNode.Value = rowList[1]["ID"].ToString(); ///设置根节点的Key值
		rootNode.Expanded = isExpanded;
		rootNode.Selected = true;

		///添加根节点
		tv.Nodes.Add(rootNode);

		///创建其他节点
		CreateChildNode(rootNode,dataTable,isExpanded,sSelectedData);
	}

	private void CreateChildNode(TreeNode parentNode,DataTable dataTable,bool isExpanded,
		   string sSelectedData)
	{
		///选择数据时，添加了排序表达式OrderBy
		DataRow[] rowList = dataTable.Select("ParentID='" + parentNode.Value + "'","OrderBy");
		foreach(DataRow row in rowList)
		{   ///创建新节点
			TreeNode node = new TreeNode();
			///设置节点的属性
			node.Text = row["Name"].ToString();
			node.Value = row["ID"].ToString();
			node.Expanded = isExpanded;
			if(node.Value == sSelectedData)
			{
				node.Selected = true;
			}

			parentNode.ChildNodes.Add(node);
			///递归调用，创建其他节点
			CreateChildNode(node,dataTable,isExpanded,sSelectedData);
		}
	}

	public SqlDataReader GetCatalogs()
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetCatalogs",out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public void GetCatalogDS(ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetCatalogs",ref ds);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public SqlDataReader GetSingleCatalog(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;
		
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSingleCatalog",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public void GetSubCatalogDS(int nCatalogID,int nRowCount,ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID)
		};

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSubCatalog",param,ref ds,0,nRowCount);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public SqlDataReader GetSubCatalog(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSubCatalog",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetAncestorCatalog(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetAncestorCatalog",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public int AddCatalog(string sName,int nParentID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,100,sName),
			sqlHelper.CreateInParam("@ParentID",SqlDbType.Int,4,nParentID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddCatalog",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateCatalog(int nCatalogID,string sName)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID),
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,100,sName)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateCatalog",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}	

	public int UpdateCatalogOrder(int nCatalogID,string sMoveFlag)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID),
			sqlHelper.CreateInParam("@MoveFlag",SqlDbType.VarChar,10,sMoveFlag)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateCatalogOrder",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteCatalog(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteCatalog",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteCatalogUrl(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteCatalogUrl",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	#endregion
}

public class Url:IUrl
{
	#region IUrl 成员

	public SqlDataReader GetUrlByCatalog(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetUrlByCatalog",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public int AddUrl(int nCatalogID,string sUrl)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID),
			sqlHelper.CreateInParam("@Url",SqlDbType.VarChar,255,sUrl)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddUrl",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteUrl(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteUrl",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	#endregion
}
