﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SQLHelper;

public interface IContent
{
	SqlDataReader GetContents();

	void GetContentDSByKey(string sKey,ref DataSet ds);
	void GetGenericInfoDS(byte bColumnID,ref DataSet ds);
	void GetContentDSByCatalog(int nCatalogID,ref DataSet ds);
	void GetContentDSByCatalog(int nCatalogID,ref DataSet ds,int nRowCount);
	SqlDataReader GetContentAttachment(int nContentID,EPictureAttachment pa);	
	SqlDataReader GetContentByCatalog(int nCatalogID);
	SqlDataReader GetSingleContent(int nContentID);
	SqlDataReader GetGenericInfoLast(byte bColumnID);

	int AddContent(string sName,string sDesn,bool bType,int nUserID,
		int nCatalogID);
	int AddGenericInfo(string sName,string sDesn,DateTime dCreateDate,int nUserID,byte bColumnID);

	int UpdateContent(int nContentID,string sName,string sDesn);
	int UpdateContentInfoID(int nContentID,int nContentInfoID);
	int UpdateContentLastViewer(int nContentID,string sLastViewer);
	int DeleteContent(int nContentID);
}

public interface IContentInfo
{
	SqlDataReader GetContentInfo();
	SqlDataReader GetSingleContentInfo(int nContentInfoID);
	int AddContentInfo();
	int UpdateViewCount(int nContentInfoID);
	int UpdatedpFlag(int nContentInfoID,short ndpFlag);
	int UpdatadpFlagDelete(int nContentInfoID,short ndpFlag);
	int DeleteContentInfo(int nContentInfoID);
}

/// <summary>
/// Content 的摘要说明
/// </summary>
public class Content:IContent
{
	public Content()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

	#region IContent 成员

	public SqlDataReader GetContents()
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetContents",out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetGenericInfoLast(byte bColumnID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ColumnID",SqlDbType.TinyInt,8,bColumnID)
		};

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetGenericInfoLast",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public void GetContentDSByKey(string sKey,ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@Key",SqlDbType.VarChar,50,sKey)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSearchByKey",param,ref ds);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public void GetContentDSByCatalog(int nCatalogID,ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetContentByCatalog",param,ref ds);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public void GetContentDSByCatalog(int nCatalogID,ref DataSet ds,
		int nRowCount)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetContentByCatalog",param,ref ds,0,nRowCount);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public void GetGenericInfoDS(byte bColumnID,ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ColumnID",SqlDbType.TinyInt,4,bColumnID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetGenericInfo",param,ref ds);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public SqlDataReader GetContentByCatalog(int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetContentByCatalog",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetSingleContent(int nContentID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSingleContent",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetContentAttachment(int nContentID,EPictureAttachment pa)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentID),
			sqlHelper.CreateInParam("@dpFlag",SqlDbType.SmallInt,2,(short)pa)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetContentAttachment",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public int AddContent(string sName,string sDesn,bool bType,
		int nUserID,int nCatalogID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,1000,sName),
			sqlHelper.CreateInParam("@Desn",SqlDbType.Text,2147483647,sDesn),
			sqlHelper.CreateInParam("@Type",SqlDbType.Bit,1,bType),
			sqlHelper.CreateInParam("@UserID",SqlDbType.Int,4,nUserID),
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddContent",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int AddGenericInfo(string sName,string sDesn,DateTime dCreateDate,
		int nUserID,byte bColumnID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,1000,sName),
			sqlHelper.CreateInParam("@Desn",SqlDbType.Text,2147483647,sDesn),
			sqlHelper.CreateInParam("@CreateDate",SqlDbType.DateTime,8,dCreateDate),
			sqlHelper.CreateInParam("@UserID",SqlDbType.Int,4,nUserID),
			sqlHelper.CreateInParam("@ColumnID",SqlDbType.TinyInt,4,bColumnID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddGenericInfo",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateContent(int nContentID,string sName,string sDesn)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentID),
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,1000,sName),
			sqlHelper.CreateInParam("@Desn",SqlDbType.Text,2147483647,sDesn)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateContent",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateContentInfoID(int nContentID,int nContentInfoID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentID),
			sqlHelper.CreateInParam("@ContentInfoID",SqlDbType.Int,4,nContentInfoID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateContentInfoID",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateContentLastViewer(int nContentID,string sLastViewer)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();		

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentID),
			sqlHelper.CreateInParam("@LastViewer",SqlDbType.VarChar,50,sLastViewer)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateContentLastViewer",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteContent(int nContentID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteContent",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	#endregion
}

public class ContentInfo:IContentInfo
{
	///
	#region IContentInfo 成员

	public SqlDataReader GetContentInfo()
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetContentInfo",out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetSingleContentInfo(int nContentInfoID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentInfoID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSingleContentInfo",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public int AddContentInfo()
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;		
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddContentInfo");
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateViewCount(int nContentInfoID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentInfoID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateViewCount",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdatedpFlag(int nContentInfoID,short ndpFlag)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentInfoID),
			sqlHelper.CreateInParam("@dpFlag",SqlDbType.SmallInt,2,ndpFlag)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdatedpFlag",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdatadpFlagDelete(int nContentInfoID,short ndpFlag)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentInfoID),
			sqlHelper.CreateInParam("@dpFlag",SqlDbType.SmallInt,2,ndpFlag)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdatedpFlagDelete",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteContentInfo(int nContentInfoID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nContentInfoID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteContentInfo",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	#endregion
}
