﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SQLHelper;

public interface IDocument
{
	SqlDataReader GetDocumentByContent(int nContentID);
	SqlDataReader GetSingleDocument(int nDocumentID);
	int AddDocument(string sName,string sUrl,string sType,int nContentInfoID,
		short bdpFlag);
	int UpdateDocument(int nDocumentID,string sName);
	int DeleteDocument(int nDocumentID);
}

/// <summary>
/// Document 的摘要说明
/// </summary>
public class Document:IDocument
{
	public Document()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

	#region IDocument 成员
	

	public SqlDataReader GetDocumentByContent(int nContentID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ContentID",SqlDbType.Int,4,nContentID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetDocumentByContent",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetSingleDocument(int nDocumentID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nDocumentID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSingleDocument",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public int AddDocument(string sName,string sUrl,string sType,
		int nContentInfoID,short bdpFlag)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,200,sName),
			sqlHelper.CreateInParam("@Url",SqlDbType.VarChar,255,sUrl),
			sqlHelper.CreateInParam("@Type",SqlDbType.VarChar,50,sType),
			sqlHelper.CreateInParam("@ContentInfoID",SqlDbType.Int,4,nContentInfoID),
			sqlHelper.CreateInParam("@dpFlag",SqlDbType.SmallInt,2,bdpFlag)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddDocument",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateDocument(int nDocumentID,string sName)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nDocumentID),
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,200,sName)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateDocument",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteDocument(int nDocumentID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nDocumentID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteDocument",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	#endregion
}
