﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SQLHelper;

/// <summary>
/// OperationTree 的摘要说明
/// </summary>
public class OperationTree
{
	public OperationTree()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

	public void InitOperationTree(TreeView tv)
	{
		DataSet ds = new DataSet("Operation");
		GetOperations(ref ds);
		if(ds.Tables.Count <= 0)
		{
			return;
		}

		tv.Nodes.Clear();     ///清空树的所有节点
		DataTable dt = ds.Tables[0];
		DataRow[] rowList = dt.Select("ParentID='0'");
		if(rowList.Length <= 0) return;

		///创建根节点
		TreeNode root = new TreeNode();
		///设置根节点属性
		root.Text = rowList[0]["Name"].ToString();
		///设置根节点的value值
		root.Value = rowList[0]["ID"].ToString();
		root.Target = rowList[0]["Target"].ToString();
		root.NavigateUrl = rowList[0]["Url"].ToString();
		root.Expanded = true;

		///添加根节点
		tv.Nodes.Add(root);

		///创建其他节点
		CreateChildNode(root,dt);
	}

	private void CreateChildNode(TreeNode parentNode,DataTable dt)
	{
		///选择数据时，添加了排序表达式OrderBy
		DataRow[] rowList = dt.Select("ParentID='" + parentNode.Value
			+ "'","OrderBy");
		foreach(DataRow row in rowList)
		{   ///创建新节点
			TreeNode node = new TreeNode();
			///设置节点的属性
			node.Text = row["Name"].ToString();
			node.Value = row["ID"].ToString();
			node.Target = row["Target"].ToString();
			node.NavigateUrl = row["Url"].ToString();
			parentNode.ChildNodes.Add(node);
			///递归调用，创建其他节点
			CreateChildNode(node,dt);
		}
	}

	public void GetOperations(ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetOperations",ref ds);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{   ///关闭数据库的链接
			sqlHelper.Close();
		}
	}
}

public class SystemConfigure
{
	public void GetSystemConfigure(ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSystemConfigure",ref ds);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{   ///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public int SaveAsSystemConfigure(string sName,string sValue)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,200,sName),
			sqlHelper.CreateInParam("@Value",SqlDbType.VarChar,1000,sValue)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_SaveAsSystemConfigure",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}
}
