﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SQLHelper;

public interface IRole
{
	SqlDataReader GetRoles();
	SqlDataReader GetSingleRole(int nRoleID);
	SqlDataReader GetRoleAuthenticate(int nRoleID);
	int AddRole(string sName);
	int UpdateRole(int nRoleID,string sName);
	int AddRoleAuthenticate(int nRoleID,int nCatalogID,Boolean bdwFlag);
	int DeleteRoleAuthenticate(int nRoleID);
	int DeleteRole(int nRoleID);
}

/// <summary>
/// Role 的摘要说明
/// </summary>
public class Role:IRole
{
	public Role()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

	#region IRole 成员

	public SqlDataReader GetRoles()
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetRoles",out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetSingleRole(int nRoleID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nRoleID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSingleRole",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetRoleAuthenticate(int nRoleID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nRoleID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetRoleAuthenticate",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public int AddRole(string sName)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,50,sName)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddRole",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateRole(int nRoleID,string sName)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nRoleID),
			sqlHelper.CreateInParam("@Name",SqlDbType.VarChar,50,sName)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateRole",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int AddRoleAuthenticate(int nRoleID,int nCatalogID,bool bdwFlag)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {			
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nRoleID),
			sqlHelper.CreateInParam("@CatalogID",SqlDbType.Int,4,nCatalogID),
			sqlHelper.CreateInParam("@dwFlag",SqlDbType.Bit,1,bdwFlag)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddRoleAuthenticate",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteRoleAuthenticate(int nRoleID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nRoleID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteRoleAuthenticate",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteRole(int nRoleID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nRoleID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteRole",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	#endregion
}
