﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Web.Caching;

public enum Column
{
	Content    = 0,
	News = 1,
	Plan = 2,
	Board = 3,
	Advice = 4,
	OfficePlan = 5,
	Other = 6
}


/// <summary>
/// 频道链接的类型
/// </summary>
public enum EChannelLocalUrl
{
	Local = 0x0000,
	Url = 0x00001
}

/// <summary>
/// 链接类型
/// </summary>
public enum EUrl
{
	Local = 0x0000,
	Http = 0x0100,
	Ftp = 0x0101,
	Email = 0x0110,
	Other = 0x1000
}

/// <summary>
/// 标识内容和链接
/// </summary>
public enum EContentUrl
{
	Content = 0x0000,
	Url = 0x0001
}

/// <summary>
/// 标识内容包含图片和附件
/// </summary>
public enum EPictureAttachment
{
	Normal  = 0,
	Attachment = 1,
	Picture = 2,	
	PictureAndAttachment = 3
}

/// <summary>
/// 标识文档能否下载（链接是否可见）
/// </summary>
public enum ERoleDownLoad
{
	NoVisible = 0x0000,
	Visible = 0x0001
}

/// <summary>
/// SystemConst 的摘要说明
/// </summary>
public class SystemConst
{
	public SystemConst()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

	public const string CONTENTIDKEY = "CONTENTID";
	public const string CONTENTINFOIDKEY = "CONTENTINFOID";

	public const string Catalog_Cache_Value_Key = "CatalogCacheKey";

	public const string ROLEIDKEY = "ROLEID";
	public const string USERIDKEY = "USERID";

	public const string COLUMNIDKEY = "COLUMNID";

	public const string URLIDKEY = "URLID";

	public const int TEXTBOXSINGLEHEIGHT = 18;
	public const int TEXTBOXMUTLILINEHEIGHT = 300;

	public const int Relation_Content_View_Count = 8;
	public const int Equal_Content_View_Count = 20;
	public const int Page_Content_Count = 20;
	public const int Catalog_View_Count = 6;
}

public class SysInfomation
{
	static int _calendarstringlength = 12;
	static int _indexrightstringlength = 30;
	static int _newslength = 1000;
	static int _planlength = 800;
	static int _adviceCount = 5;
	static int _boardCount = 6;
	static int _catalogCount = 6;
	static int _contentCount = 20;
	static int _contentNameLength = 70;
	static int _contentNameListLength = 28;

	public SysInfomation()
	{
		///
	}

	public static void SystemInit()
	{
		SystemConfigure sc = new SystemConfigure();
		DataSet ds;
		ds = (DataSet)SQLHelper.CacheData.GetCacheValue("SystemConfigure");
		if(ds == null)
		{
			ds = new DataSet();
			sc.GetSystemConfigure(ref ds);
			SQLHelper.CacheData.CacheObjectValue("SystemConfigure",ds);
		}
		if(ds.Tables.Count <= 0)
		{
			return;
		}

		///初始化系统变量
		foreach(DataRow row in ds.Tables[0].Rows)
		{
			switch(row["Name"].ToString())
			{
				case "NewsLength":
					{
						_newslength = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "PlanLength":
					{
						_planlength = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "AdviceCount":
					{
						_adviceCount = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "BoardCount":
					{
						_boardCount = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "CatalogCount":
					{
						_catalogCount = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "ContentLength":
					{
						_contentNameLength = Int32.Parse(row["Value"].ToString().Trim());

						break;
					}
				case "ContentListCount":
					{
						_contentCount = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "ContentListLength":
					{
						_contentNameListLength = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "CalendarContentNameLength":
					{
						_calendarstringlength = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				case "IndexRightNameLength":
					{
						_indexrightstringlength = Int32.Parse(row["Value"].ToString().Trim());
						break;
					}
				default: break;
			}
		}
	}

	/// <summary>
	/// 数据为空
	/// </summary>
	public static string DATA_ISNULL =
		"数据为空，请检查你的操作数据是否正确？";

	/// <summary>
	/// 移动操作信息
	/// </summary>
	public static string MOVE_DATA_SUCESS =
		"移动数据成功，请妥善保管好你的数据。";
	public static string MOVE_DATA_ERROR =
		"移动数据失败，请检查你的操作或数据是否正确？";
	
	/// <summary>
	/// 删除操作信息
	/// </summary>
	public static string DELETE_DATA_SUCESS =
		"删除数据成功，请妥善保管好你的数据。";
	public static string DELETE_DATA_ERROR =
		"删除数据失败，请检查你的操作或数据是否正确？";

	/// <summary>
	/// 添加操作信息
	/// </summary>
	public static string ADD_DATA_SUCESS =
		"添加数据成功，请妥善保管好你的数据。";
	public static string ADD_DATA_ERROR =
		"添加数据失败，请检查你的操作或数据是否正确？";

	/// <summary>
	/// 修改操作信息
	/// </summary>
	public static string UPDATE_DATA_SUCESS =
		"修改数据成功，请妥善保管好你的数据。";
	public static string UPDATE_DATA_ERROR =
		"修改数据失败，请检查你的操作或数据是否正确？";

	/// <summary>
	/// 选择操作信息
	/// </summary>
	public static string SELECT_DATA_SUCESS =
		"选择数据成功，请妥善保管好你的数据。";
	public static string SELECT_DATA_ERROR =
		"选择数据失败，请检查你的操作或数据是否正确？";
	public static string SELECT_DATA_NO_ITEM =
		"你没有选择操作的数据，请检查你的操作或数据是否正确？";

	public static int CalendarStringLength
	{
		get
		{
			return _calendarstringlength;
		}
	}

	public static int IndexRightStringLength
	{
		get
		{
			return _indexrightstringlength;
		}
	}

	public static int NewsLength
	{
		get
		{
			return _newslength;
		}
	}

	public static int PlanLength
	{
		get
		{
			return _planlength;
		}
	}


	public static int AdviceCount
	{
		get
		{
			return _adviceCount;
		}
	}


	public static int BoardCount
	{
		get
		{
			return _boardCount;
		}
	}

	public static int CatalogCount
	{
		get
		{
			return _catalogCount;
		}
	}

	public static int ContentCount
	{
		get
		{
			return _contentCount;
		}
	}

	public static int ContentNameLength
	{
		get
		{
			return _contentNameLength;
		}
	}

	public static int ContentNameListLength
	{
		get
		{
			return _contentNameListLength;
		}
	}
}

/// <summary>
/// SysOperation 的摘要说明
/// </summary>
public class SysOperation
{
	public SysOperation()
	{
		///
	}

	public static string OpenDialog(string msg)
	{
		return ("<script>alert('" + msg + "')</script>");
	}

	public static bool StringNullChecked(string str)
	{
		if(str == null || str == "" || str.Length < 1)
		{
			return false;
		}
		return true;
	}

	public static void SetListSelected(DropDownList list,string value)
	{
		if(list.Items.Count <= 0)
		{
			list.SelectedIndex = -1;
			return;
		}
		for(int i = 0; i < list.Items.Count; i++)
		{
			if(list.Items[i].Value == value)
			{
				list.SelectedIndex = i;
				return;
			}
		}
		list.SelectedIndex = -1;
	}

	public static void SetListSelected(ListBox list,string value)
	{
		if(list.Items.Count <= 0)
		{
			list.SelectedIndex = -1;
			return;
		}
		for(int i = 0; i < list.Items.Count; i++)
		{
			if(list.Items[i].Value == value)
			{
				list.SelectedIndex = i;
				return;
			}
		}
		list.SelectedIndex = -1;
	}

	public static string FormatErrorUrl(string url)
	{
		if(url.IndexOf("?") > 0)
		{
			return(url.Substring(0,url.IndexOf("?")));
		}
		return(url);
	}

	public static string FormatErrorPageUrl(string url,string message)
	{
		return ("~/Portal/ErrorPage.aspx?ErrorMsg=" + message
			+ "&ErrorUrl=" + url.Replace("\n","").Replace("\t",""));
	}

	public static DataSet CacheCatalogData()
	{
		ICatalog catalog = new Catalog();
		/// ***** 添加缓存代码
		DataSet ds = (DataSet)SQLHelper.CacheData.GetCacheValue(SystemConst.Catalog_Cache_Value_Key);
		if(ds == null)
		{
			ds = new DataSet();
			catalog.GetCatalogDS(ref ds);
			SQLHelper.CacheData.CacheObjectValue(SystemConst.Catalog_Cache_Value_Key,
				(object)ds);
		}
		return ds;
	}

	public static SiteMapNode SiteMapResolve(object sender,SiteMapResolveEventArgs e)
	{
		SiteMapNode curNode = SiteMap.CurrentNode.Clone(true);
		SiteMapNode tempNode = curNode;

		///修改访问的页面是显示具体内容的链接地址
		if(e.Context.Request.RawUrl.IndexOf("ViewContent.aspx") > -1)
		{   ///不修改内容的显示地址,把当前目录设置到它的父级目录
			tempNode = tempNode.ParentNode;
		}

		///修改二级目录的链接地址,此时的请求地址位为：
		if(null != e.Context.Request.QueryString["CurCatalogID"]
			&& null != e.Context.Request.QueryString["CatalogID"]
			&& null != tempNode)
		{
			///修改链接地址
			string catalogID = e.Context.Request.QueryString["CatalogID"].ToString();
			string curCatalogID = e.Context.Request.QueryString["CurCatalogID"].ToString();
			tempNode.Url = tempNode.Url + "?CatalogID=" + catalogID.ToString()
				+ "&CurCatalogID=" + curCatalogID.ToString();
			tempNode.Title = GetCatalogName(Int32.Parse(curCatalogID));
			tempNode = tempNode.ParentNode;
		}

		///修改一级目录的链接地址,此时的请求地址位为：
		if(null != e.Context.Request.QueryString["CatalogID"] && null != tempNode)
		{
			///修改链接地址
			string catalogID = e.Context.Request.QueryString["CatalogID"].ToString();
			tempNode.Url = "ViewCatalog.aspx?CatalogID=" + catalogID.ToString();
			tempNode.Title = GetCatalogName(Int32.Parse(catalogID));
			///把父级目录设为空
			if(null != tempNode.ParentNode)
			{
				tempNode.ParentNode = null;
			}			
		}		
		return (curNode);
	}

	private static string GetCatalogName(int nCatalogID)
	{
		DataSet ds = SysOperation.CacheCatalogData();
		if(ds == null || ds.Tables.Count <= 0)
		{
			return string.Empty;
		}
		string cname = string.Empty;
		DataRow[] rowList = ds.Tables[0].Select(
			"ID='" + nCatalogID.ToString() + "'");
		if(rowList.Length == 1)
		{
			cname = rowList[0]["Name"].ToString();
		}
		return cname;
	}

	public static string CreateFileNameByDateTime()
	{
		DateTime now = DateTime.Now;
		string fileName = now.Year.ToString()
			+ now.Month.ToString()
			+ now.Day.ToString()
			+ now.Hour.ToString()
			+ now.Minute.ToString()
			+ now.Second.ToString()
			+ now.Millisecond.ToString();
		return (fileName);
	}

	public static string FormatStringLength(string str,int length)
	{
		if(SysOperation.StringNullChecked(str) == false)
		{
			return string.Empty;
		}
		///如果包含中文字符，中文字符的长度加倍
		if(Encoding.UTF8.GetByteCount(str) > str.Length)
		{   ///调整为中文的长度，等于英文的一半
			length = length / 2;
		}
		if(str.Length > length)
		{
			return str.Substring(0,length)
				+ "...";
		}
		return str;
	}
}
