﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SQLHelper;

public interface IUser
{
	SqlDataReader GetUsers();
	void GetUserDS(ref DataSet ds);
	SqlDataReader GetSingleUser(int nUserID);
	SqlDataReader GetUserLogin(string sUserName,string sPassword);
	int AddUser(string sUserName,string sPassword,string sEmail,
		int nRoleID);
	int UpdateUser(int nUserID,string sEmail);
	int UpdateUserPwd(int nUserID,string sPassword);
	int UpdateUserRole(int nUserID,int nRoleID);
	int DeleteUser(int nUserID);
}

/// <summary>
/// User 的摘要说明
/// </summary>
public class User:IUser
{
	public User()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

	#region IUser 成员

	public SqlDataReader GetUsers()
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetUsers",out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}
	
	public void GetUserDS(ref DataSet ds)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();		

		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetUsers",ref ds);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{   ///关闭数据库的链接
			sqlHelper.Close();
		}
	}

	public SqlDataReader GetUserLogin(string sUserName,string sPassword)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@UserName",SqlDbType.VarChar,50,sUserName),
			sqlHelper.CreateInParam("@Password",SqlDbType.VarChar,255,sPassword)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetUserLogin",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public SqlDataReader GetSingleUser(int nUserID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		///定义保存从数据库获取的结果的DataReader
		SqlDataReader dr = null;

		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nUserID)
		};
		try
		{
			///执行存储过程
			sqlHelper.RunProc("Pr_GetSingleUser",param,out dr);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}

		///返回从数据库获取的结果
		return (dr);
	}

	public int AddUser(string sUserName,string sPassword,string sEmail,
		int nRoleID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@UserName",SqlDbType.VarChar,50,sUserName),
			sqlHelper.CreateInParam("@Password",SqlDbType.VarChar,255,sPassword),
			sqlHelper.CreateInParam("@Email",SqlDbType.VarChar,255,sEmail),
			sqlHelper.CreateInParam("@RoleID",SqlDbType.Int,4,nRoleID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_AddUser",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateUser(int nUserID,string sEmail)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nUserID),
			sqlHelper.CreateInParam("@Email",SqlDbType.VarChar,255,sEmail)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateUser",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateUserPwd(int nUserID,string sPassword)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nUserID),
			sqlHelper.CreateInParam("@Password",SqlDbType.VarChar,255,sPassword)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateUserPwd",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int UpdateUserRole(int nUserID,int nRoleID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nUserID),
			sqlHelper.CreateInParam("@RoleID",SqlDbType.Int,8,nRoleID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_UpdateUserRole",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	public int DeleteUser(int nUserID)
	{
		///定义类SQLHelper
		SQLHelper.SQLHelper sqlHelper = new SQLHelper.SQLHelper();

		int nResult = -1;
		///添加存储过程的参数
		SqlParameter[] param = {
			sqlHelper.CreateInParam("@ID",SqlDbType.Int,4,nUserID)
		};
		try
		{
			///执行存储过程
			nResult = sqlHelper.RunProc("Pr_DeleteUser",param);
		}
		catch(Exception ex)
		{
			///抛出执行数据库异常
			SystemError.SystemLog(ex.Message);
			throw new Exception(ex.Message,ex);
		}
		finally
		{
			///关闭数据库的链接
			sqlHelper.Close();
		}

		///返回从数据库获取的结果
		return (nResult);
	}

	#endregion
}
