﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Content_Admin_AddCatalog : System.Web.UI.Page
{
	int nCatalogID = -1;
    protected void Page_Load(object sender, EventArgs e)
    {
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(Request.Params["CatalogID"] != null)
		{
			if(Int32.TryParse(Request.Params["CatalogID"].ToString(),out nCatalogID) == false)
			{
				return;
			}
		}
		if(!Page.IsPostBack)
		{
			if(nCatalogID > -1)
			{
				InitCatalog(nCatalogID);
			}
		}
		AddBtn.Enabled = nCatalogID > -1 ? true : false;				
    }
	private void InitCatalog(int nCatalogID)
	{
		ICatalog cata = new Catalog();
		SqlDataReader dr = cata.GetSingleCatalog(nCatalogID);
		if(dr.Read())
		{
			CurCatalog.Text = dr["Name"].ToString();
		}
		dr.Close();
	}

	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}		
		switch(sCmdName)
		{
			case "add":
				{
					AddCatalog();
					break;
				}
			case "return":
				{
					Response.Redirect("~/Content/Admin/Catalog.aspx?CatalogID="
						+ nCatalogID.ToString());
					break;
				}			
			default: break;
		}
	}

	private void AddCatalog()
	{
		ICatalog cata = new Catalog();

		try
		{
			int nNewCatalogID = cata.AddCatalog(Name.Text.Trim(),nCatalogID);
			if(nNewCatalogID > -1 && cbUrl.Checked == true)
			{
				IUrl url = new Url();
				url.AddUrl(nNewCatalogID,tbUrl.Text.Trim());
			}
			Response.Write(SysOperation.OpenDialog(
					SysInfomation.ADD_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}
	protected void cbUrl_CheckedChanged(object sender,EventArgs e)
	{
		tbUrl.Enabled = cbUrl.Checked;
	}
}
