﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Content_Admin_BoardManage:System.Web.UI.Page
{
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(!Page.IsPostBack)
		{
			BindBoardData();
		}
	}
	private void BindBoardData()
	{
		IContent content = new Content();
		DataSet ds = new DataSet("Board");
		content.GetGenericInfoDS((byte)Column.Board,ref ds);

		ContentView.DataSource = ds;
		ContentView.DataBind();
	}

	protected string FormatContentState(short sState)
	{
		switch(sState)
		{
			case 0:
				return "未审核";
			case 1:
				return "审核未通过";
			case 2:
				return "审核已通过";
			case 3:
				return "已发布";
			case 4:
				return "已存档";
			default:
				return "未知状态";
		}
	}
	protected string FormatContentdpFlag(short sdpFlag)
	{
		switch(sdpFlag)
		{
			case 0:
				///"无附件";
				return "";
			case 1:
				///"附件";
				return "~/Images/Attch.gif";
			case 2:
				///"图片";
				return "~/Images/pic.gif";
			case 3:
				///"图片和附件";
				return "~/Images/paa.gif";
			default:
				///"未知状态";
				return "~/Images/unknown.gif";
		}
	}

	protected bool FormatImageVisible(short visible)
	{
		return visible == 0 ? false : true;
	}

	protected void NewContentBtn_Click(object sender,EventArgs e)
	{
		Response.Redirect("~/Content/Admin/AddGenericInfo.aspx?ColumnID=" + ((byte)Column.Board).ToString());
	}
	protected void ContentView_PageIndexChanging(object sender,GridViewPageEventArgs e)
	{
		ContentView.PageIndex = e.NewPageIndex;
		BindBoardData();
	}

	protected void ContentView_RowDataBound(object sender,GridViewRowEventArgs e)
	{
		ImageButton deleteBtn = (ImageButton)e.Row.FindControl("DeleteBtn");
		if(deleteBtn != null)
		{
			deleteBtn.Attributes.Add("onclick","return confirm('你确定要删除所选择的数据吗?');");
		}
	}
	protected void ContentView_RowCommand(object sender,GridViewCommandEventArgs e)
	{
		if(e.CommandName == "delete")
		{
			IContent content = new Content();
			try
			{
				content.DeleteContent(Int32.Parse(e.CommandArgument.ToString()));
				Response.Write(SysOperation.OpenDialog(
						SysInfomation.DELETE_DATA_SUCESS));
			}
			catch(Exception ex)
			{
				Server.Transfer(SysOperation.FormatErrorPageUrl(
					SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
					false);
			}
		}
	}
	protected void ContentView_RowDeleting(object sender,GridViewDeleteEventArgs e)
	{
		///
	}
}
