﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;

public partial class Content_Admin_Catalog : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(!Page.IsPostBack)
		{
			InitCatalogView();
		}
		DeleteBtn.Attributes.Add("onclick","return confirm('你确定要删除所选择的数据吗?');");
    }

	private void InitCatalogView()
	{
		ICatalog cata = new Catalog();
		cata.BindCatalogTreeView(CatalogView,true,"-1");
	}

	protected void OperationBtn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			Response.Write(SysOperation.OpenDialog(
				SysInfomation.DATA_ISNULL));
			return;
		}
		if(CatalogView.SelectedNode == null)
		{
			Response.Write(SysOperation.OpenDialog(
				SysInfomation.SELECT_DATA_NO_ITEM));
			return;
		}
		switch(sCmdName)
		{
			case "add":
				{
					Response.Redirect("~/Content/Admin/AddCatalog.aspx?CatalogID="
						+ CatalogView.SelectedNode.Value);
					break;
				}
			case "update":
				{
					Response.Redirect("~/Content/Admin/UpdateCatalog.aspx?CatalogID="
						+ CatalogView.SelectedNode.Value);
					break;
				}
			case "delete":
				{
					DeleteCatalog(Int32.Parse(CatalogView.SelectedNode.Value));
					break;
				}
			case "up":
			case "down":
				{
					MoveCatalog(Int32.Parse(CatalogView.SelectedNode.Value),sCmdName);
					break;
				}			
			default: break;
		}
	}

	private void DeleteCatalog(int nCatalogID)
	{
		if(CatalogView.SelectedNode.ChildNodes.Count > 0)
		{
			Response.Write(
				SysOperation.OpenDialog(
				"要删除的结点包含孩子结点，不能删除，请重新选择结点。")
				);
			return;
		}
		ICatalog cata = new Catalog();

		try
		{
			cata.DeleteCatalog(nCatalogID);
			InitCatalogView();

			Response.Write(SysOperation.OpenDialog(
				SysInfomation.DELETE_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}

	private void MoveCatalog(int nCatalogID,string sMoveFlag)
	{
		if(SysOperation.StringNullChecked(sMoveFlag) == false)
		{
			Response.Write(SysOperation.OpenDialog(
				SysInfomation.DATA_ISNULL));
			return;
		}
		TreeNode parentNode = CatalogView.SelectedNode.Parent;
		if(parentNode == null)
		{
			return;
		}
		///第一个结点不上移
		if(sMoveFlag == "up"
			&& parentNode.ChildNodes.IndexOf(CatalogView.SelectedNode) == 0)
		{
			Response.Write(
				SysOperation.OpenDialog(
				"第一个结点不上移，请重新选择结点。")
				);
			return;
		}
		///最后一个结点不下移
		if(sMoveFlag == "down"
			&& parentNode.ChildNodes.IndexOf(CatalogView.SelectedNode)
			== parentNode.ChildNodes.Count - 1)
		{
			Response.Write(
				SysOperation.OpenDialog(
				"最后一个结点不下移，请重新选择结点。")
				);
			return;
		}

		ICatalog cata = new Catalog();
		try
		{
			cata.UpdateCatalogOrder(nCatalogID,sMoveFlag);
			InitCatalogView();

			Response.Write(SysOperation.OpenDialog(
				SysInfomation.MOVE_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}	
}
