﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class _Default : System.Web.UI.Page 
{
	protected string ProjectNews;
	protected string NewsID;
	protected string ProjectPlan;
	protected string PlanID;

    protected void Page_Load(object sender, EventArgs e)
    {
		BindViewData(BoardView,Column.Board);
		BindViewData(AdviceView,Column.Advice);

		ShowData(ref ProjectNews,ref NewsID,Column.News);
		ShowData(ref ProjectPlan,ref PlanID,Column.Plan);

		PlanCalendar.VisibleDate = DateTime.Now;
    }

	private void BindViewData(GridView view,Column column)
	{
		IContent content = new Content();
		DataSet ds = new DataSet(Enum.GetName(typeof(Column),column));
		content.GetGenericInfoDS((byte)column,ref ds);

		view.DataSource = ds;
		view.DataBind();
	}

	private void ShowData(ref string data,ref string ID,Column column)
	{
		IContent content = new Content();
		SqlDataReader dr = content.GetGenericInfoLast((byte)column);

		if(dr.Read())
		{
			data = SysOperation.FormatStringLength(
				dr["Desn"].ToString().Replace("\n","<br>　　"),
				SysInfomation.NewsLength);
			ID = dr["ID"].ToString();
		}
		dr.Close();
	}

	protected void ibt_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{
			case "login":
				{
					//UserLogin();
					break;
				}
			case "register":
				{
					Response.Write("<script>window.open('" + "Portal/Register.aspx" + "');</script>"); 
					break;
				}			
			default: break;
		}
	}

	private void UserLogin()
	{
		///
	}
	protected void PlanCalendar_SelectionChanged(object sender,EventArgs e)
	{
		Response.Write("<script>window.open('Portal/ViewPlan.aspx')</script>");
	}
}
