﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Portal_Search:System.Web.UI.Page
{
	string skey;
	protected void Page_Load(object sender,EventArgs e)
	{
		if(null != Request.QueryString["SearchKey"])
		{
			skey = Request.QueryString["SearchKey"].ToString();
			if(null == tbKey.Text || string.Empty == tbKey.Text
				|| string.Empty == tbKey.Text.Trim())
			{
				tbKey.Text = skey;
			}
		}
		if(!Page.IsPostBack)
		{
			BindContentData(skey);
		}
	}

	private void BindContentData(string sKey)
	{
		PageTd.Visible = false;
		SearchMsg.Text = "你搜索的关键字为：<b>" + tbKey.Text + "</b>，结果为空。";
		if(null == tbKey.Text || string.Empty == tbKey.Text
			|| string.Empty == tbKey.Text.Trim()
			|| tbKey.Text.Length <= 0)
		{			
			return;
		}

		IContent content = new Content();
		DataSet ds = new DataSet("Content");
		content.GetContentDSByKey(sKey,ref ds);

		ContentView.DataSource = ds;
		ContentView.DataBind();

		///设置分页按钮的是否可用
		SetPageButton();
		SetCurrentIndexStr();
		if(ContentView.PageCount <= 0)
		{
			tbMove.Enabled = false;
			return;
		}
		
		///设置验证的按钮的最大值
		rvPage.MaximumValue = ContentView.PageCount.ToString();
		PageTd.Visible = true;
		SearchMsg.Text = "你搜索的关键字为：<b>" + tbKey.Text + "</b>";
	}

	protected string FormatContentUrl(string url,bool bType,
		int nID,int nCurCatalogID,int nCatalogID)
	{
		if(bType == true)
		{
			return "ViewContent.aspx?ContentID=" + nID.ToString()
				+ "&CurCatalogID=" + nCurCatalogID.ToString()
				+ "&CatalogID=" + nCatalogID.ToString();
		}
		else
		{
			return url;
		}
	}

	protected string FormatContentTarget(bool bType)
	{
		return bType == true ? "_self" : "_blank";
	}
	
	protected void PageBtn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}		
		switch(sCmdName)
		{
			case "prev":
				{
					ContentView.PageIndex = Math.Max(0,ContentView.PageIndex - 1);
					break;
				}
			case "next":
				{
					ContentView.PageIndex = Math.Min(ContentView.PageCount - 1,ContentView.PageIndex + 1);
					break;
				}
			case "move":
				{
					int page = Int32.Parse(tbMove.Text.Trim());
					if(page > 0 && page <= ContentView.PageCount)
					{
						ContentView.PageIndex = page - 1;
					}
					break;
				}
			default: break;
		}

		BindContentData(tbKey.Text.Trim());
	}

	private void SetPageButton()
	{
		if(ContentView.PageCount <= 1)
		{
			PrevBtn.Enabled = NextBtn.Enabled = false;
			return;
		}
		if(ContentView.PageIndex == 0)
		{
			PrevBtn.Enabled = false;
			NextBtn.Enabled = true;
		}
		if(ContentView.PageIndex == ContentView.PageCount - 1)
		{
			PrevBtn.Enabled = true;
			NextBtn.Enabled = false;
		}
	}

	private void SetCurrentIndexStr()
	{
		CurrentIndex.Text = "当前第" + (ContentView.PageIndex + 1).ToString()
			+ "页，共" + ContentView.PageCount.ToString() + "页";
	}
	protected void ibtSearch_Click(object sender,ImageClickEventArgs e)
	{
		BindContentData(tbKey.Text.Trim());
	}
}
