﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Portal_ViewCatalog:System.Web.UI.Page
{
	protected int nCatalogID = -1;
	int nCurCatalogID = -1;
	protected void Page_Load(object sender,EventArgs e)
	{   ///获取父级目录CatalogID
		if(Request.Params["CatalogID"] != null)
		{
			if(Int32.TryParse(Request.Params["CatalogID"].ToString(),out nCatalogID) == false)
			{
				return;
			}
		}
		///获取当前频道CatalogID
		if(Request.Params["CurCatalogID"] != null)
		{
			if(Int32.TryParse(Request.Params["CurCatalogID"].ToString(),out nCurCatalogID) == false)
			{
				return;
			}
		}

		if(nCatalogID > 0)
		{
			BindCatalogData(nCatalogID);
			if(nCurCatalogID > 0)
			{
				BindContentData(nCurCatalogID);
			}
		}				
	}	

	private void BindContentData(int nCurCatalogID)
	{
		IContent content = new Content();
		DataSet ds = new DataSet("Content");
		content.GetContentDSByCatalog(nCurCatalogID,ref ds);

		ContentView.DataSource = ds;
		ContentView.DataBind();

		///设置分页按钮的是否可用
		SetPageButton();
		SetCurrentIndexStr();
		if(ContentView.PageCount <= 0)
		{
			tbMove.Enabled = false;
			PrevBtn.Enabled = NextBtn.Enabled = false;			
			return;
		}
		///设置验证的按钮的最大值
		rvPage.MaximumValue = ContentView.PageCount.ToString();
	}

	private void BindCatalogData(int nCatalogID)
	{
		ICatalog cata = new Catalog();
		DataSet ds = new DataSet();
		cata.GetSubCatalogDS(nCatalogID,SysInfomation.CatalogCount,ref ds);
		CatalogView.DataSource = ds;
		CatalogView.DataBind();

		if(nCurCatalogID <= 0 && CatalogView.Rows.Count > 0)
		{
			nCurCatalogID = Int32.Parse(CatalogView.DataKeys[0]["ID"].ToString());
		}
	}

	protected string FormatCatalogUrl(int nUrlID,string url,
		int nCurCatalogID)
	{
		if(nUrlID == 0)
		{
			return Request.ApplicationPath
				+ "/Portal/ViewCatalog.aspx?CatalogID="
				+ nCatalogID.ToString()
				+ "&CurCatalogID=" + nCurCatalogID.ToString();
		}
		else
		{
			return (url);
		}
	}

	protected string FormatContentUrl(string url,bool bType,int nContentID,
		int nCurCatalogID)
	{
		if(bType == true)
		{
			return "ViewContent.aspx?ContentID=" + nContentID.ToString()
				+ "&CatalogID=" + nCatalogID.ToString()
				+ "&CurCatalogID=" + nCurCatalogID.ToString();				
		}
		else
		{
			return url;
		}
	}

	protected string FormatContentTarget(bool bType)
	{
		return bType == true ? "_self" : "_blank";
	}

	protected void PageBtn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{
			case "prev":
				{
					ContentView.PageIndex = Math.Max(0,ContentView.PageIndex - 1);
					break;
				}
			case "next":
				{
					ContentView.PageIndex = Math.Min(ContentView.PageCount - 1,ContentView.PageIndex + 1);
					break;
				}
			case "move":
				{
					int page = Int32.Parse(tbMove.Text.Trim());
					if(page > 0 && page <= ContentView.PageCount)
					{
						ContentView.PageIndex = page -1;
					}
					break;
				}
			default: break;
		}

		BindContentData(nCurCatalogID);
	}

	private void SetPageButton()
	{
		if(ContentView.PageCount <= 1)
		{
			PrevBtn.Enabled = NextBtn.Enabled = false;
			ibtnMove.Enabled = false;
			return;
		}
		if(ContentView.PageIndex == 0)
		{
			PrevBtn.Enabled = false;
			NextBtn.Enabled = true;
		}
		if(ContentView.PageIndex == ContentView.PageCount -1)
		{
			PrevBtn.Enabled = true;
			NextBtn.Enabled = false;
		}
		tbMove.Enabled = true;
	}

	private void SetCurrentIndexStr()
	{
		CurrentIndex.Text = "当前第" + (ContentView.PageIndex + 1).ToString()
			+ "页，共" + ContentView.PageCount.ToString() + "页";
	}

	protected void SearchBtn_Click(object sender,ImageClickEventArgs e)
	{
		Response.Write("<script>window.open('Search.aspx?SearchKey="
			+ Server.UrlEncode(SearchKey.Text.Trim())
			+ "')</script>");
	}
}
