﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Portal_ViewContent : System.Web.UI.Page
{
	protected string Body;
	protected string Name;
	protected string CreateDate;

	int nContentID = -1;
	int nCurCatalogID = -1;
	int nCatalogID = -1;
    protected void Page_Load(object sender, EventArgs e)
    {
		///获取父级目录CatalogID
		if(Request.Params["CatalogID"] != null)
		{
			if(Int32.TryParse(Request.Params["CatalogID"].ToString(),out nCatalogID) == false)
			{
				return;
			}
		}
		///获取当前频道CatalogID
		if(Request.Params["CurCatalogID"] != null)
		{
			if(Int32.TryParse(Request.Params["CurCatalogID"].ToString(),out nCurCatalogID) == false)
			{
				return;
			}
		}
		///获取当前频道ContentID
		if(Request.Params["ContentID"] != null)
		{
			if(Int32.TryParse(Request.Params["ContentID"].ToString(),out nContentID) == false)
			{
				return;
			}
		}

		if(!Page.IsPostBack)
		{
			ShowContentData(nContentID);
			BindContentData(nCurCatalogID);
		}
    }

	private void ShowContentData(int nContentID)
	{
		IContent content = new Content();
		SqlDataReader dr = content.GetSingleContent(nContentID);

		if(dr.Read())
		{
			Name = dr["Name"].ToString();
			Body = dr["Desn"].ToString().Replace("\n","<br>　　").Replace("\t","<br>");
			CreateDate = Convert.ToDateTime(dr["CreateDate"].ToString()).ToShortDateString();
		}
		dr.Close();

		BindPictureData(nContentID);
		BindAttachmentData(nContentID);
	}

	private void BindContentData(int nCatalogID)
	{
		IContent content = new Content();
		DataSet ds = new DataSet("Content");
		content.GetContentDSByCatalog(nCatalogID,ref ds,
			SystemConst.Equal_Content_View_Count);

		ContentView.DataSource = ds;
		ContentView.DataBind();		
	}

	private void BindPictureData(int nContentID)
	{
		IContent content = new Content();
		SqlDataReader dr = content.GetContentAttachment(
			nContentID,EPictureAttachment.Picture);

		ContentPicView.DataSource = dr;
		ContentPicView.DataBind();
		dr.Close();
	}

	private void BindAttachmentData(int nContentID)
	{
		IContent content = new Content();
		SqlDataReader dr = content.GetContentAttachment(
			nContentID,EPictureAttachment.Attachment);

		AttachmentView.DataSource = dr;
		AttachmentView.DataBind();
		dr.Close();

		attchmentdiv.Visible = AttachmentView.Rows.Count <= 0 ? false : true;
	}

	private void BindRelContentData(int nContentID)
	{
		///显示相关新闻
	}

	protected string FormatContentUrl(string url,bool bType,int nContentID)
	{
		if(bType == true)
		{
			return "ViewContent.aspx?ContentID=" + nContentID.ToString()
				+ "&CurCatalogID=" + nCurCatalogID.ToString()
				+ "&CatalogID=" + nCatalogID.ToString();
		}
		else
		{
			return url;
		}
	}

	protected string FormatContentTarget(bool bType)
	{
		return bType == true ? "_self" : "_blank";
	}

	protected void SearchBtn_Click(object sender,ImageClickEventArgs e)
	{
		Response.Write("<script>window.open('Search.aspx?SearchKey="
			+ Server.UrlEncode(SearchKey.Text.Trim())
			+ "')</script>");
	}
}
