﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Portal_ViewUser:System.Web.UI.Page
{
	int nUserID = -1;
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Request.Params["UserID"] != null)
		{
			if(Int32.TryParse(Request.Params["UserID"].ToString(),out nUserID) == false)
			{
				return;
			}
		}
		if(!Page.IsPostBack)
		{
			BindRoleData();
			if(nUserID > -1)
			{
				BindUserData(nUserID);
			}
		}
	}

	private void BindUserData(int nUserID)
	{
		IUser user = new User();
		SqlDataReader dr = user.GetSingleUser(nUserID);
		if(dr.Read())
		{
			tbUserName.Text = dr["UserName"].ToString();
			tbEmail.Text = dr["Email"].ToString();
			SysOperation.SetListSelected(RoleList,dr["RoleID"].ToString());
		}
		dr.Close();
	}
	private void BindRoleData()
	{
		IRole role = new Role();
		SqlDataReader dr = role.GetRoles();

		RoleList.DataSource = dr;
		RoleList.DataTextField = "Name";
		RoleList.DataValueField = "ID";
		RoleList.DataBind();

		dr.Close();
	}
	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{				
			case "return":
				{
					Response.Redirect("~/Admin/UserManage.aspx");
					break;
				}
			default: break;
		}
	}
}
