﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserControls_PopupCalendar:System.Web.UI.UserControl
{
	DateFormatString _datefstring = DateFormatString.String;
	public enum DateFormatString
	{
		String,
		ShortDateString,
		ShortTimeString,
		LongDateString,
		LongTimeString
	}
		
	public string SelectedDate
	{
		get
		{
			return tbDate.Text.Trim();
		}
	}

	public DateFormatString SelectedDateFormatString
	{
		get
		{
			return _datefstring;
		}
		set
		{
			_datefstring = value;
		}
	}

	protected void Page_Load(object sender,EventArgs e)
	{
		if(!Page.IsPostBack)
		{
			tbDate.Text = FormatDateString(DateTime.Now,_datefstring); ;
			pnlCalendar.Attributes.Add("style","DISPLAY: none; POSITION: absolute");
		}
		else
		{
			string id;
			string eventtarget = Page.Request.Form["__EVENTTARGET"];
			if(eventtarget == null || eventtarget == "")
			{
				id = string.Empty;
			}
			else
			{
				if(eventtarget.IndexOf(pnlCalendar.ID) > -1)
				{
					id = eventtarget.Substring(0,eventtarget.IndexOf("$"));
					if(id != ID)
					{
						pnlCalendar.Attributes.Add("style","DISPLAY: none; POSITION: absolute");
					}
					else
					{
						pnlCalendar.Attributes.Add("style","POSITION: absolute");
					}
				}
			}

		}
		Page.ClientScript.RegisterClientScriptBlock(GetType(),"Script_Panel" + ID,"<script> function On" + ID + "Click() {  if(" + ID + "_pnlCalendar.style.display == \"none\")     " + ID + "_pnlCalendar.style.display = \"\";   else    " + ID + "_pnlCalendar.style.display = \"none\"; } </script>");
		btnPopup.Attributes.Add("OnClick","On" + ID + "Click()");

	}
	protected void cCalendar_SelectionChanged(object sender,EventArgs e)
	{
		tbDate.Text = FormatDateString(cCalendar.SelectedDate,_datefstring);
		pnlCalendar.Attributes.Add("style","DISPLAY: none; POSITION: absolute");
	}

	private string FormatDateString(DateTime datetime,DateFormatString dataformatstring)
	{
		switch(dataformatstring)
		{
			case DateFormatString.String:
				return datetime.ToString();
			case DateFormatString.ShortDateString:
				return datetime.ToShortDateString();
			case DateFormatString.ShortTimeString:
				return datetime.ToShortTimeString();
			case DateFormatString.LongDateString:
				return datetime.ToLongDateString();
			case DateFormatString.LongTimeString:
				return datetime.ToLongTimeString();
			default: return datetime.ToString();
		}
	}
}
