using System;
using System.Collections.Generic;
using System.Text;

using YL.Common;
using System.Data;
using System.Data.OleDb;

namespace YL.BLL
{
    public class AArticle
    {
        public static int Add(string title, string summary, string content, string typeId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Article (title,summary,content,typeId,aTime) values (@title,@summary,@content,@typeId,@aTime)");
            OleDbParameter[] param = 
            {
                OleDbHelper.GetParameter("@title",OleDbType.VarChar,50,"[title]",title),
                OleDbHelper.GetParameter("@summary",OleDbType.VarChar,50,"[summary]",summary),
                OleDbHelper.GetParameter("@content",OleDbType.VarChar,2000,"[content]",content),
                OleDbHelper.GetParameter("@typeId",OleDbType.Integer,4,"[typeId]",Convert.ToInt32(typeId)),
                OleDbHelper.GetParameter("@aTime",OleDbType.Date,8,"[aTime]",DateTime.Now)
            };
            return OleDbHelper.ExecuteSql(sb.ToString(), param);
        }

        public static int Update(string title, string summary, string content, string typeId, string aid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Article set title=@title,summary=@summary,content=@content,typeId=@typeId,aTime=aTime where aid=@aid");
            OleDbParameter[] param = 
            {
                OleDbHelper.GetParameter("@title",OleDbType.VarChar,50,"[title]",title),
                OleDbHelper.GetParameter("@summary",OleDbType.VarChar,50,"[summary]",summary),
                OleDbHelper.GetParameter("@content",OleDbType.VarChar,2000,"[content]",content),
                OleDbHelper.GetParameter("@typeId",OleDbType.Integer,4,"[typeId]",Convert.ToInt32(typeId)),
                OleDbHelper.GetParameter("@aTime",OleDbType.Date,8,"[aTime]",DateTime.Now),
                OleDbHelper.GetParameter("@aid",OleDbType.Integer,4,"[aid]",Convert.ToInt32(aid))
            };
            return OleDbHelper.ExecuteSql(sb.ToString(), param);
        }

        public static int UpdateNum(string aid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Article set aNum=aNum+1 where aid=@aid");
            OleDbParameter[] param = 
            {
                OleDbHelper.GetParameter("@aid",OleDbType.Integer,4,"[aid]",Convert.ToInt32(aid))
            };
            return OleDbHelper.ExecuteSql(sb.ToString(), param);
        }


        public static DataTable GetTopN(string num, string orderBy)
        {
            return OleDbHelper.ExecuteDt("select top " + num + " * from Article order by " + orderBy + " desc");
        }

        public static DataTable GetById(string aid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select * from Article where aid=@aid");
            OleDbParameter[] param = 
            {
                OleDbHelper.GetParameter("@aid",OleDbType.Integer,4,"[aid]",Convert.ToInt32(aid))
            };
            return OleDbHelper.ExecuteDt(sb.ToString(), param);
        }

        public static DataTable GetTypeId(string typeId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select * from Article where typeId=@typeId");
            OleDbParameter[] param = 
            {
                OleDbHelper.GetParameter("@typeId",OleDbType.Integer,4,"[typeId]",Convert.ToInt32(typeId))
            };
            return OleDbHelper.ExecuteDt(sb.ToString(), param);
        }
    }
}
