﻿using System;
using System.Collections.Generic;
using System.Text;

using YL.Common;
using System.Data;
using System.Data.OleDb;
//该源码下载自www.51aspx.com(５１aｓｐｘ．ｃｏｍ)

namespace YL.BLL
{
    /// <summary>
    /// 注册用户表
    /// </summary>
    public class ARegUser
    {
        /// <summary>
        /// 根据帐号查找数据库名
        /// </summary>
        /// <param name="LoginNum"></param>
        /// <returns></returns>
        public static string GetDbName(string LoginNum)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select DbName from ARegUser where LoginNum=@LoginNum");
            OleDbParameter[] param =  
            { 
                OleDbHelper.GetParameter("@LoginNum", OleDbType.Integer, 4, "[LoginNum]",Convert.ToInt32(LoginNum))
            };
            DataTable dt = OleDbHelper.ExecuteDt(sb.ToString(), param);
            if (dt.Rows.Count > 0)
                return dt.Rows[0][0].ToString();
            else
                return "";
        }
        /// <summary>
        /// 取得全部
        /// </summary>
        /// <returns></returns>
        public static DataTable GetAll()
        {
            return OleDbHelper.ExecuteDt("select * from ARegUser");
        }
    }
}
