﻿// JavaScript Document
/*=====================================================================
'代码版权说明
'=====================================================================
' 文件名: PopupMenu.js
' 版本:	  1.0
' 日期:   2006-8-8
' 作者:	  笑咪咪
' 说明:	  
' 修改记录: 
' 版权所有：重庆卓越电脑网络科技公司
'=====================================================================
' Copyright (C) 2006 zydn.net All rights reserved.
' Web: http://www.zydn.net
' Need help? Contact: Hermit_Dragon@163.com
'=====================================================================*/

function Keyboard()
{
	this.Keys=new Object();
	this.Keys[48]="0";
	this.Keys[49]="1";
	this.Keys[50]="2";
	this.Keys[51]="3";
	this.Keys[52]="4";
	this.Keys[53]="5";
	this.Keys[54]="6";
	this.Keys[55]="7";
	this.Keys[56]="8";
	this.Keys[57]="9";
	this.Keys[65]="A";
	this.Keys[66]="B";
	this.Keys[67]="C";
	this.Keys[68]="D";
	this.Keys[69]="E";
	this.Keys[70]="F";
	this.Keys[71]="G";
	this.Keys[72]="H";
	this.Keys[73]="I";
	this.Keys[74]="J";
	this.Keys[75]="K";
	this.Keys[76]="L";
	this.Keys[77]="M";
	this.Keys[78]="N";
	this.Keys[79]="O";
	this.Keys[80]="P";
	this.Keys[81]="Q";
	this.Keys[82]="R";
	this.Keys[83]="S";
	this.Keys[84]="T";
	this.Keys[85]="U";
	this.Keys[86]="V";
	this.Keys[87]="W";
	this.Keys[88]="X";
	this.Keys[89]="Y";
	this.Keys[90]="Z";
}

function MenuItem(Text,Action,Disabled)
{
	this.IsSeparator=false;
	this.Text=typeof(Text)=="undefined"?null:Text;
	this.Action=typeof(Action)=="undefined"?null:Action;
	this.Disabled=typeof(Disabled)=="undefined"?false:Disabled;
}

function Accelerator(CtrlKey,HotKey,Action)
{
	this.CtrlKey=typeof(CtrlKey)=="undefined"?null:CtrlKey;
	this.HotKey=typeof(HotKey)=="undefined"?null:HotKey;
	this.Action=typeof(Action)=="undefined"?null:Action;
}



function AcceleratorManager(Name)
{
	this.Accelerators=new Object();
	this.KeyString=new Keyboard();
	this.Name=typeof(Name)=="undefined"?"AcceleratorManager":Name;
	this.PopupMenu=null;
	window.document.body.setAttribute(this.Name,this);
	this.SendMessage=function(Name,event,IsCtrl){
		var strkey;
		if(event==null)return true;
		var theObj=window.document.body.getAttribute(Name);
		if(event.ctrlKey)
		{
				for(var Item in theObj.Accelerators)
				{
					if(theObj.Accelerators[Item].CtrlKey!=null)
					{
						strkey=theObj.Accelerators[Item].CtrlKey.split("+");
						if(strkey!=null)
						{
							if(typeof(strkey[1])!="undefined"&&typeof(theObj.KeyString.Keys[event.keyCode])!="undefined")
							{
								if(strkey[1]==theObj.KeyString.Keys[event.keyCode])
								{
									if(theObj.Accelerators[Item].Action!=null)
									{
										event.returnValue=false;
										eval(theObj.Accelerators[Item].Action);
										return false;
									}
								}
							}
						}
					}
				}
		}
		else
		{
			if(!IsCtrl)return true;
			if(typeof(theObj.PopupMenu)=="undefeind")return true;
			for(var Item in theObj.Accelerators)
			{
					strkey=theObj.Accelerators[Item].HotKey;
					if(strkey!=null)
					{
						if(strkey==theObj.KeyString.Keys[event.keyCode])
						{
							if(theObj.Accelerators[Item].Action!=null)
							{
								event.returnValue=false;
								eval(theObj.Accelerators[Item].Action);
								return false;
							}
						}
					}
			}
		}
		return true;
	}
}

function PopupMenu(Rect,Name)
{
	this.Container=window.createPopup();
	this.EventTarget=null;
	this.MenuItems=new Object();
	this.Styles=new Object();
	this.Name=typeof(Name)=="undefined"?"PopupMenu":Name;
	this.Rect=new Size(0,0);
	this.IsShow=false;
	if(Rect instanceof Size) this.Rect=Rect;
	this.AcceleratorManager=null;
	
	window.document.body.setAttribute(this.Name,this);

	this.Hidden=function(){
		this.Container.hide();
		this.IsShow=false;
	}
	
	this.Update=function(){
		var doc=this.Container.document;
		doc.open();
		doc.writeln("<html>");
		doc.writeln("<head>");
		if(this.AcceleratorManager!=null)
		{
			doc.writeln("<script language=\"javascript\">");
			doc.writeln("document.onkeydown=new Function(\"window.document.body.getAttribute('AcceleratorManager').SendMessage(window.document.body.getAttribute('AcceleratorManager').Name,window.event,true);\");");
			doc.writeln("</script>");
		}
		this.InitializeStyle(doc);
		doc.writeln("</head>");
		doc.writeln("<body oncontextmenu=\"return false;\" onselectstart=\"return false;\">");
		doc.writeln("<div id=\""+this.Name+"Border\" class=\"PopupPanelBorder\">")
		doc.writeln("<div id=\""+this.Name+"\" class=\"PopupPanel\">")
		this.InitializeMenu(doc,this.MenuItems);
		doc.writeln("</div>");
		doc.writeln("</div>");
		doc.writeln("</body>");
		doc.writeln("</html>");
		doc.close();
		this.Container.document.body.setAttribute("PopupMenu",this);
		if(this.AcceleratorManager!=null)
		{
			this.Container.document.body.setAttribute("AcceleratorManager",this.AcceleratorManager);
		}
	}

	this.InitializeStyle=function(doc){
		for(var Item in this.Styles)
		{
			doc.writeln(this.Styles[Item]);
		}
	}
	
	this.InitializeMenu=function(doc,IniMenus){
		var className,hotKey,ctrlKey;
		for(var Item in IniMenus)
		{
			if(IniMenus[Item].IsSeparator)
			{
				doc.writeln("<hr id=\""+Item+"\" class=\"MenuSeparator\"/>");
			}
			else
			{
				hotKey="";
				ctrl="";
				
				if(this.AcceleratorManager!=null)
				{
					if(typeof(this.AcceleratorManager.Accelerators[Item])!="undefined")
					{
						if(this.AcceleratorManager.Accelerators[Item].HotKey!=null)
							hotKey="(<span style=\"text-decoration: underline;\">"+this.AcceleratorManager.Accelerators[Item].HotKey+"</span>)";
						if(this.AcceleratorManager.Accelerators[Item].CtrlKey!=null)
							ctrl=this.AcceleratorManager.Accelerators[Item].CtrlKey;
					}
				}
	
				if(IniMenus[Item].Disabled)
					className="class=\"UnActiveDisabledMenuItem\" isDisabled=\"true\"";
				else
					className="class=\"UnActiveMenuItem\" isDisabled=\"false\"";
					
				doc.writeln("<div id=\""+Item+"\" "+className+" onmouseover=\"window.document.body.getAttribute('PopupMenu').MouseOver(this);\" onmouseout=\"window.document.body.getAttribute('PopupMenu').MouseOut(this);\" ActiveClass=\"ActiveMenuItem\" UnActiveClass=\"UnActiveMenuItem\" ActiveDisabledClass=\"ActiveDisabledMenuItem\" UnActiveDisabledClass=\"UnActiveDisabledMenuItem\" onclick=\"if(this.getAttribute('isDisabled')=='true'){return false;}var PopupMenu=window.document.body.getAttribute('PopupMenu');PopupMenu.MouseOut(this);"+IniMenus[Item].Action+";\"><span class=\"TextPanel\">"+IniMenus[Item].Text+"<span class=\"HotKeyPanel\">"+hotKey+"</span></span><span class=\"ControlPanel\">"+ctrl+"</span></div>");
			}
		}
	}
	
	this.MouseOver=function(target){
		if(target.getAttribute("isDisabled")=="true")
			target.className=target.getAttribute("ActiveDisabledClass");
		else
			target.className=target.getAttribute("ActiveClass");
	}
	
	this.MouseOut=function(target){
		if(target.getAttribute("isDisabled")=="true")
			target.className=target.getAttribute("UnActiveDisabledClass");
		else
			target.className=target.getAttribute("UnActiveClass");
	}

	this.Show=function(Name,event,target){
		var theObj=window.document.body.getAttribute(Name);
		theObj.EventTarget=event.srcElement;
		var X=event.clientX;
		if((theObj.Rect.Width+X)>target.document.body.offsetWidth) X-=theObj.Rect.Width;
		theObj.Update();
		theObj.Container.show(X,event.clientY,theObj.Rect.Width,theObj.Rect.Height,target);
		theObj.IsShow=true;
		event.returnValue=false;
	}
}

/*=======================================================================
    创建右键菜单
	
	var TimePopup=new PopupMenu(new Size(70,90));
	TimePopup.MenuItems["ShowInfo"]=new Menu("查看","parent.Pop_Show();");
	var Separator=new Menu();
	Separ.IsSeparator=true;
	TimePopup.MenuItems["Separator"]=Separator;
	TimePopup.MenuItems["Confirm"]=new Menu("批准","parent.Pop_Auding(true);");
	TimePopup.MenuItems["Refuse"]=new Menu("拒绝","parent.Pop_Auding(false);");
	TimePopup.Styles["PopupStyle"]="<link type=\"text/css\" rel=\"stylesheet\" href=\"../Style/Popup.css\" />";
*/