﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="CodeHighlight.aspx.cs" Inherits="CodeHighlight"  %>
<%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="TagCloud" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
   <title>Winson.Framework_代码高亮控件的使用</title>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="Title" Runat="Server">
   <h2>代码高亮控件的使用</h2>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <h5>一、基本说明：</h5>
<p>
    之前一直在使用 CodeHighlight 控件来完成代码高亮，现在我发现了另一个更加好的控件，使用的是jQuery的一个插件，之所以说其好，主要有以下几个原因：<br />
 <div class="list">
<ul>
<li>使用的是JS完成代码高亮，节省服务器资源，效率比较高</li>
<li>可以非常灵活地自定义高亮的关键字和规则，同时也可以增加自定义高亮语法</li>
<li>可完全自定义高亮代码的风格，因为所有样式直接通过CSS完成</li>
<li>不需要任何配置，即可马上使用</li>
<li>在复制代码时，只需选择要复制的代码段，然后即会弹出复制框，这时只需点击一下里面的内容，即可自动复制到剪贴板了</li>
<li>复制代码时，不会将行号也一并复制</li>
</ul>
</div> 
不过使用此控件，感觉唯一不太理想的一点就是不支持代码折叠，不过其实这一功能用得不多，比起之前的服务器端的 CodeHighlight 控件，这点缺点还是可以接受的，呵
  
 <br /><br />
  <h5>二、相关的JS文件：</h5>
此控件用到的JS文件包括以下2个，均是放在本项目的目录下：<br />

<div class="detail">
<ul>
<li><span class="parm">Js/Plugins/Chili/jquery.chili.js</span>&nbsp;&nbsp;主文件，完成高亮的核心功能</li>
<li><span class="parm">Js/Plugins/Chili/recipes.js</span>&nbsp;&nbsp;自定义高亮语法文件，可在这里修改你自己的语法规则</li>
</ul>
</div> 


此插件使用了 &lt;per&gt; 和 &lt;code&gt; 元素，所以也可以定义这2个元素的CSS，本项目里是在 Css/base.css 里对其进行了定义。
  
    <h5>三、使用说明：</h5>
    
 
 此控件使用非常简单，只需将要高亮的代码放到&lt;per&gt; 和 &lt;code&gt; 元素块里，然后为  &lt;code&gt; 设置好相应的 css 样式即可，代码如下：
<pre><code class="html" lineNumbers="true">
&lt;pre&gt;&lt;code class="csharp"&gt;
Test test = new Test();
&lt;/code&gt;&lt;/pre&gt;
</code></pre>

<span class="comment">这里要注意的是，在代码块里的代码，如果包含了 “<” 或者 “>”号等HTML标记，必须要使用转换符代替</span><br /><br />

如要为代码块里添加显示行数功能，只需在页面添加以下JS代码即可：

<pre><code class="js">
ChiliBook.lineNumbers = true;//高亮代码显示行数
</code></pre>

第二种方法是直接为某个要显示行数的代码块设置，只需在 code 添加 <span class="parm">lineNumbers="true"</span> 参数即可，此参数优先级高于上面的JS代码指定，代码如下：
<pre><code class="html" >
&lt;pre&gt;&lt;code class="csharp" lineNumbers="true" &gt;
Test test = new Test();
&lt;/code&gt;&lt;/pre&gt;
</code></pre>

目前本控件支持的高亮语法有以下几种：<br /><br />

<table class="table-context">
<tr><td width="100" >语言</td><td width="150">对应的class名称</td></tr>
<tr><td>C#</td><td>csharp</td></tr>
<tr><td>HTML/ASP.NET</td><td>html</td></tr>
<tr><td>JavaScript</td><td>js</td></tr>
<tr><td>CSS</td><td>css</td></tr>
<tr><td>MSSQL</td><td>sql</td></tr>
<tr><td>C++</td><td>cpp</td></tr>
<tr><td>Java</td><td>java</td></tr>
<tr><td>XML</td><td>xml</td></tr>
<tr><td>MSSQL/MYSQL</td><td>sql</td></tr>
</table>
<br />
如要添加更多的语法支持，直接修改 <span class="parm">Js/Plugins/Chili/recipes.js</span> 即可，至于添加的方法，主要是以正则匹配，大家可到此控件的官方网站上去看看：http://noteslog.com/chili/
</p>

</asp:Content>

