﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Data_add.aspx.cs" Inherits="Data_add" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
<title>Winson.Framework功能演示_新增数据</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="Title" Runat="Server">
<h2>新增数据演示</h2>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<h5>一、基本说明：</h5>

<p>    要向数据库里插入一条或者多条记录，在Winson.Framework3.0里此操作已变得非常轻松！<br /><br />
       在新增操作中，未赋值的字段将会自动以数据库里的默认值代替</p>
<h5>二、操作步骤：</h5>
<P class="comment">注：以下演示均以WinsonFrameDB数据库的 Test 表为例:</P>
<p><h4>1、新增单个实体到数据库：</h4><br />
操作步骤如下：<br /><br />
 a.引用以下命名空间：
<pre>
<code class="csharp">using Winson.EntityOP;</code></pre>

b.实例化一个实体操作类，此实体操作类已包括了实体类和所有相关的操作方法：
<pre><code class="csharp">Test test = new Test();</code></pre>

c.为实体赋值，其中 <span class="comment">Entity</span> 为实体类属性，所有实体操作类里都可通过此属性直接调用其实体里所有成员属性：
<pre><code class="csharp">
test.Entity.Age = 20;
test.Entity.Name = "Winson";
test.Entity.Datetime = System.DateTime.Now;
</code></pre>

d.调用新增的方法，向数据库进行新增操作，此方法返回影响的记录行数：
<pre><code class="csharp">test.Add();</code></pre>

e.完整的代码如下：
<pre><code class="csharp">
Test test = new Test();
test.Entity.Age = 20;
test.Entity.Name = "Winson";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context";
if (test.Add() > 0 ) //判断是否添加成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>


<p><h4>2、批量新增实体到数据库：</h4><br />
批量新增步骤 a-c 与单实体操作一样，从 d 步骤开始要创建一个新实体，同时添加到集合里，以下步骤从 d 开始：<br /><br />
d.需将以上实体添加到集合里，然后再创建另一个新实体，为新实体赋值，不断重复此步骤即可添加多个实体了：
<pre><code class="csharp">
test.AppendEntity(); //将第一个实体追加到实体集合里
test.CreateEntity(); //创建另一个新实体
//为新实体赋值
test.Entity.Age = 30;
test.Entity.Name = "第二个实体";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context 02";
test.AppendEntity(); //将新实体再追加到实体集合里
</code></pre>

e.调用批量新增的方法，向数据库进行新增操作，此方法返回一个布尔值，成功为True，否则为False：
<pre><code class="csharp">test.AddBatch();</code></pre>


f.完整的代码如下：
<pre><code class="csharp">
Test test = new Test();
test.Entity.Age = 20;
test.Entity.Name = "Winson";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context";
test.AppendEntity(); //将第一个实体追加到实体集合里
test.CreateEntity(); //创建另一个新实体
//为新实体赋值
test.Entity.Age = 30;
test.Entity.Name = "第二个实体";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context 02";
test.AppendEntity(); //将新实体再追加到实体集合里
if (test.AddBatch()) //判断是否添加成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>

<p><h4>3、对 <span class="comment">image</span> 数据类型的操作：</h4><br />
    在3.0版里已可支持所有数据类型，包括image等byte[]类型，在Test表里有一个image类型的字段，如要向此字段添加数据，只需直接为其赋值即可：
<br /><br />
由于image类型是流文件类型，因此需要使用byte[]类型的数据进行操作，以下步骤可以将以下文件转成byte[]数据：
<pre><code class="csharp">
//引用命名空间
using Winson.Framework.Utility;

//获取图片文件（或者其他文件也可以）
byte[] b = Utility.ReadFile(@"d:\01.jpg");

Test test = new Test();
test.Entity.Pic = b;//直接将byte[]数据赋值到相关的字段即可
test.Add();
</code></pre>
关于将数据库里的图片文件读出，可以使用　<span class="comment">Utility.writeFile</span>　方法实现，此方法已在<a href="Data_select.aspx">查询数据</a>栏目里有所介绍了，在此不再详述。

<h5>三、效果演示：</h5>

<p><h4>1、新增单个实体到数据库：</h4><br />

<div id="AddOne">

<ul style="height: 30px;"> <li><a href="#AddOne-1"><span>　演　示　</span></a></li> <li><a href="#AddOne-2"><span>　源　码　</span></a></li>  <li><a href="#AddOne-3"><span>　查  询　</span></a></li>

</ul> 

<div id="AddOne-1">
<span class="comment">以下各项为空时则自动使用数据库的默认值进行新增</span><br />
姓名：<input ID="TestName" Class="input" /><br />
年龄：<input ID="TestAge" Class="input"/><br />
是否：<select id="TestIsUse">
        <option value="True">是</option>
        <option value="False">否</option>
        </select>
    <br />
内容：<input ID="TestContext" Class="input"/><br />
要添加到数据库的图片绝对路径（如 D:\test.jpg）：
<input ID="TestPic" Class="input"/>
<br /><br />
<Button ID="TestAdd" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;新&nbsp;&nbsp;&nbsp;&nbsp;增&nbsp;&nbsp;</Button>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
  
 </div> 
 
<div id="AddOne-2"> 

<pre><code class="csharp">
private void Add()
{
    test = new Test();
    test.Entity.Name = String.IsNullOrEmpty(Request["Name"]) ? "" : Request["Name"];
    test.Entity.Age = String.IsNullOrEmpty(Request["Age"]) ? 0 : Convert.ToInt32(Request["Age"]);
    test.Entity.Context = String.IsNullOrEmpty(Request["Context"]) ? "" : Request["Context"];

    if (!String.IsNullOrEmpty(Request["Pic"]))
    {
        byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
        test.Entity.Pic = pic;
    }
    if (test.Add() > 0)
        ReturnResult("1");
    else
        ReturnResult("0");
}
</code></pre>

 </div> 
 
 <div id="AddOne-3"> 
</div>

</div>


<p><h4>2、批量新增实体到数据库：</h4><br />

<div id="AddBatch">

<ul style="height: 30px;"> <li><a href="#AddBatch-1"><span>　演　示　</span></a></li> <li><a href="#AddBatch-2"><span>　源　码　</span></a></li>  <li><a href="#AddBatch-3"><span>　查  询　</span></a></li> 

</ul> 

<div id="AddBatch-1">
<span class="comment">以下各项为空时则自动使用数据库的默认值进行新增</span><br />
姓名：<input ID="BTestName" Class="input" /><br />
年龄：<input ID="BTestAge" Class="input"/><br />
内容：<input ID="BTestContext" Class="input"/><br />
要添加到数据库的图片绝对路径（如 D:\test.jpg）：
<input ID="BTestPic" Class="input"/><br />
要增加实体的个数：<input ID="BTestCount" Class="input" value="5"/>
<br /><br />
<Button ID="TestAddBatch" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;批量新增&nbsp;&nbsp;</Button>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 </div>
    
<div id="AddBatch-2"> 

<pre><code class="csharp">
private void AddBatch()
{
	test = new Test();
	int count = String.IsNullOrEmpty(Request["Count"]) ? 1 : Convert.ToInt32(Request["Count"]);

	for (int i = 0; i < count; i++)
	{
		test.Entity.Name = String.IsNullOrEmpty(Request["Name"]) ? "" : Request["Name"];
		test.Entity.Age = String.IsNullOrEmpty(Request["Age"]) ? 0 : Convert.ToInt32(Request["Age"]);
		test.Entity.Context = String.IsNullOrEmpty(Request["Context"]) ? "" : Request["Context"];
		if (!String.IsNullOrEmpty(Request["Pic"]))
		{
			byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
			test.Entity.Pic = pic;
		}
		//上面的第一次不用创建，从第二个实体开始就需要创建新实体了
		test.AppendEntity();
		test.CreateEntity();
	}
	if (test.AddBatch())
		ReturnResult("1");
	else
		ReturnResult("0");
}
</code></pre>

 </div> 

<div id="AddBatch-3">  
</div>

</div>

</asp:Content>

