﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Data_update.aspx.cs" Inherits="Data_update" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
<title>Winson.Framework功能演示_更新数据</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="Title" Runat="Server">
<h2>更新数据演示</h2>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<h5>一、基本说明：</h5>

<p>    要向数据库里更新一条或者多条记录，在Winson.Framework3.0里此操作已变得非常轻松！<br /><br />
       在更新操作中，未赋值的字段将不会被更新！<br /><br />
       更新操作主要有以下3种形式：<br />
       <br />
       <b>1、以实体主键更新：</b><br />
       &#160;&#160;此方法适合更新单个记录，只需在为实体赋值时，同时指定实体主键的值，即会自动以此主键进行更新。<br /><br />
       <b>2、以自定义条件更新：</b><br />
       &#160;&#160;在调用更新方法时，可以输入以　<span class="comment"><b>NameValueCollection</b></span>　对象创建的条件，具体的条件创建说明，可查看 <a href="Data_select.aspx">查询数据</a> 演示。<br /><br />
       <b>3、批量更新：</b><br />
       &#160;&#160;此方法可以一次性更新多条实体记录，每条记录均要以实体主键进行更新，因此必须为每个实体类设置期主键值，然后即可以一个实体集合形式进行一次性更新。<br /><br />
</p>
<h5>二、操作步骤：</h5>
<P class="comment">注：以下演示均以WinsonFrameDB数据库的 Test 表为例:</P>
<p><h4>1、以实体主键更新：</h4><br />
操作步骤如下：<br /><br />
 a.引用以下命名空间：
<pre>
<code class="csharp">using Winson.EntityOP;</code></pre>

b.实例化一个实体操作类，此实体操作类已包括了实体类和所有相关的操作方法：
<pre><code class="csharp">Test test = new Test();</code></pre>

c.为实体赋值，其中 <span class="comment">Entity</span> 为实体类属性，所有实体操作类里都可通过此属性直接调用其实体里所有成员属性：
<pre><code class="csharp">
//以下代码将会更新Id等于1的记录
test.Entity.Id = 1;//必须为其主键赋值
test.Entity.Age = 20;
test.Entity.Name = "Winson";
test.Entity.Datetime = System.DateTime.Now;
</code></pre>

d.调用更新的方法，向数据库进行更新操作，此方法返回影响的记录行数：
<pre><code class="csharp">test.Update();</code></pre>

e.完整的代码如下：
<pre><code class="csharp">
Test test = new Test();
test.Entity.Id = 1;//必须为其主键赋值
test.Entity.Age = 20;
test.Entity.Name = "Winson";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context";
if (test.Update() > 0 ) //判断是否添加成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>


<p><h4>2、自定义条件更新：</h4><br />
a.此方法不需指定主键，甚至如果需要的话，可以连主键一起更新，不过一般不建议去更新主键啦，只需设置好条件对象即可：
<pre><code class="csharp">
using Winson.EntityOP;
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

conditionValue["Name like"] = "winson";//更新Name里包括winson里记录

//创建实体操作类
Test test = new Test();
test.Entity.Age = 25;
test.Entity.Name = "Winson is fine";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test 22222";
</code></pre>

b.调用更新的方法，向数据库进行更新操作，此方法返回影响的记录行数：
<pre><code class="csharp">test.Update(conditionValue);</code></pre>


c.完整的代码如下：
<pre><code class="csharp">
using Winson.EntityOP;
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

conditionValue["Name like"] = "winson";//更新Name里包括winson里记录

//创建实体操作类
Test test = new Test();
test.Entity.Age = 25;
test.Entity.Name = "Winson is fine";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test 22222";
if (test.Update(conditionValue) > 0 ) //判断是否添加成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>

<p><h4>3、批量更新：</h4><br />
批量更新步骤 a-c 与单实体主键更新操作一样，从 d 步骤开始要创建一个新实体，同时添加到集合里，以下步骤从 d 开始：<br /><br />
d.需将以上实体添加到集合里，然后再创建另一个新实体，为新实体赋值，不断重复此步骤即可添加多个实体了：
<pre><code class="csharp">
test.AppendEntity(); //将第一个实体追加到实体集合里
test.CreateEntity(); //创建另一个新实体
//为新实体赋值
//每个实体均要设置好其主键
test.Entity.Id = 2;
test.Entity.Age = 30;
test.Entity.Name = "第二个实体";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context 02";
test.AppendEntity(); //将新实体再追加到实体集合里
</code></pre>

e.调用批量更新的方法，向数据库进行更新操作，此方法返回一个布尔值，成功为True，否则为False：
<pre><code class="csharp">test.UpdateBatch();</code></pre>


f.完整的代码如下：
<pre><code class="csharp">
Test test = new Test();
test.Entity.Id = 1;
test.Entity.Age = 20;
test.Entity.Name = "Winson";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context";
test.AppendEntity(); //将第一个实体追加到实体集合里
test.CreateEntity(); //创建另一个新实体
//为新实体赋值
test.Entity.Id = 2;
test.Entity.Age = 30;
test.Entity.Name = "第二个实体";
test.Entity.Datetime = System.DateTime.Now;
test.Entity.Context = "Test context 02";
test.AppendEntity(); //将新实体再追加到实体集合里
if (test.UpdateBatch()) //判断是否更新成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>

<p><h4>4、更新时使用事件处理：</h4><br />
在3.2版开始，就可以支持事件处理了，事件处理为了能更方便地在做完相应操作后可以继续后续的操作，在此只对更新操作的事件处理加以说明，其他操作的用法一样，就不再另说明了：<br /><br />
OK,先看看以下代码，大家就会明白如何使用了，其实非常简单：
<pre><code class="csharp">
 //先定义相应的事件，以下是更新后的事件
test.OnUpdated += new OPEventHandler&lt;Test&gt;(Test_OnUpdated);

//实现处理函数
void Test_OnUpdated(Test sender, OPEvent arg)
{
    //更新后可继续获取所操作的实体主键
    int id = arg.CurrId;
}
</code></pre>

在处理函数中有2个参数，其中 <span class="comment"><b>sender</b></span> 为操作的实体对象，<span class="comment"><b>arg</b></span> 为操作当前实体返回的数据，主要有2个属性，分别为 <br /> <span class="comment"><b>arg.CurrId</b></span>：代表当前操作实体的ID，用于单实体操作 <br />
<span class="comment"><b>arg.CurrBatchId</b></span> ：代表当前操作实体的ID列表，用于批量实体操作



<h5>三、效果演示：</h5>

<p><h4>1、以实体主键更新：</h4><br />

<div id="UpdateOne">

<ul style="height: 30px;"> <li><a href="#UpdateOne-1"><span>　演　示　</span></a></li> <li><a href="#UpdateOne-2"><span>　源　码　</span></a></li>  <li><a href="#UpdateOne-3"><span>　查 询　</span></a></li>

</ul> 

<div id="UpdateOne-1">
<span class="comment">以下各项为空时则自动使用数据库的默认值进行更新</span><br />
ID：<input ID="TestId" Class="input" /><br />
姓名：<input ID="TestName" Class="input" /><br />
年龄：<input ID="TestAge" Class="input"/><br />
是否：<select id="TestIsUse">
        <option value="">不更新</option>
        <option value="True">是</option>
        <option value="False">否</option>
        </select><br />
内容：<input ID="TestContext" Class="input"/><br />
要添加到数据库的图片绝对路径（如 D:\test.jpg）：
<input ID="TestPic" Class="input"/>
<br /><br />
<Button ID="TestUpdate" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;更&nbsp;&nbsp;&nbsp;&nbsp;新&nbsp;&nbsp;</Button>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
  
 </div> 
 
<div id="UpdateOne-2"> 

<pre><code class="csharp">
private void Update()
{
    test = new Test();
    test.Entity.Id = String.IsNullOrEmpty(Request["ID"]) ? 1 : Convert.ToInt32(Request["ID"]);
    test.Entity.Name = String.IsNullOrEmpty(Request["Name"]) ? "" : Request["Name"];
    test.Entity.Age = String.IsNullOrEmpty(Request["Age"]) ? 0 : Convert.ToInt32(Request["Age"]);
    test.Entity.Context = String.IsNullOrEmpty(Request["Context"]) ? "" : Request["Context"];

    if (!String.IsNullOrEmpty(Request["Pic"]))
    {
        byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
        test.Entity.Pic = pic;
    }
    if (test.Update() > 0)
        ReturnResult("1");
    else
        ReturnResult("0");
}
</code></pre>

 </div> 
 
 <div id="UpdateOne-3"> 
</div>

</div>


<p><h4>2、批量更新实体到数据库：</h4><br />

<div id="UpdateBatch">

<ul style="height: 30px;"> <li><a href="#UpdateBatch-1"><span>　演　示　</span></a></li> <li><a href="#UpdateBatch-2"><span>　源　码　</span></a></li>  <li><a href="#UpdateBatch-3"><span>　查 询　</span></a></li> 

</ul> 

<div id="UpdateBatch-1">
<span class="comment">以下各项为空时则自动使用数据库的默认值进行更新</span><br />
ID：<input ID="BTestId" Class="input" value="1,2,3,4"/>(输入要更新的多个ID，以逗号隔开)<br />
姓名：<input ID="BTestName" Class="input" /><br />
年龄：<input ID="BTestAge" Class="input"/><br />
内容：<input ID="BTestContext" Class="input"/><br />
要添加到数据库的图片绝对路径（如 D:\test.jpg）：
<input ID="BTestPic" Class="input"/><br />
<br /><br />
<Button ID="TestUpdateBatch" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;批量更新&nbsp;&nbsp;</Button>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 </div>
    
<div id="UpdateBatch-2"> 

<pre><code class="csharp">
private void UpdateBatch()
{
	try
	{
		test = new Test();
		string[] id = String.IsNullOrEmpty(Request["Id"]) ? "" : Request["Id"].Split(",");

		for (int i = 0; i < id.Length; i++)
		{
		    test.Entity.Id = Convert.ToInt32(id[i]);
		    test.Entity.Name = String.IsNullOrEmpty(Request["Name"]) ? "" : Request["Name"];
		    test.Entity.Age = String.IsNullOrEmpty(Request["Age"]) ? 0 : Convert.ToInt32(Request["Age"]);
		    test.Entity.Context = String.IsNullOrEmpty(Request["Context"]) ? "" : Request["Context"];
		    if (!String.IsNullOrEmpty(Request["Pic"]))
		    {
			    byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
			    test.Entity.Pic = pic;
		    }
		    //上面的第一次不用创建，从第二个实体开始就需要创建新实体了
		    test.AppendEntity();
		    test.CreateEntity();
		}
		if (test.UpdateBatch())
		    ReturnResult("1");
		else
		    ReturnResult("0");
	}
	catch (Exception e)
	{            
		ReturnResult("0");
	}
}
</code></pre>

 </div> 

<div id="UpdateBatch-3">  
</div>

</div>



</asp:Content>

