﻿using System;
using System.Text;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using Winson.EntityOP;
using Winson.EntityOP.Base;
using Winson.EntityOP.Entity;
using Winson.Framework.Utility;

public partial class Data_update : System.Web.UI.Page
{
    Test test;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!String.IsNullOrEmpty(Request["Action"]))
            {
                switch (Request["Action"].Trim().ToLower())
                {
                    case "update":
                        Update();
                        break;
                    case "updatebatch":
                        UpdateBatch();
                        break;
                }
            }
        }
    }

    private void Update()
    {
        try
        {
            test = new Test();

            //使用更新事件 
            test.OnUpdated += new OPEventHandler<Test>(Test_OnUpdated);

            test.Entity.Id = String.IsNullOrEmpty(Request["TestId"]) ? 1 : Convert.ToInt32(Request["TestId"]);
            
            if(!String.IsNullOrEmpty(Request["Name"]))
                test.Entity.Name = Request["Name"];
            if (!String.IsNullOrEmpty(Request["Age"]))
                test.Entity.Age = Convert.ToInt32(Request["Age"]);
            if (!String.IsNullOrEmpty(Request["Context"]))
                test.Entity.Context = Request["Context"];
            if (!String.IsNullOrEmpty(Request["IsUse"]))
                test.Entity.Isuse = Convert.ToBoolean(Request["IsUse"]);

            if (!String.IsNullOrEmpty(Request["Pic"]))
            {
                byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
                test.Entity.Pic = pic;
            }
            if (test.Update() > 0)
                ReturnResult("1");
            else
                ReturnResult("0");
        }
        catch (Exception e)
        {
            ReturnResult("0");
        }
    }
    /// <summary>
    /// 更新后执行的事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="arg"></param>
    void Test_OnUpdated(Test sender, OPEvent arg)
    {
        //更新后可继续获取所操作的实体主键
        int id = arg.CurrId;
    }

    private void UpdateBatch()
    {
        try
        {
            test = new Test();
            test.OnBatchUpdated += new OPEventHandler<Test>(Test_OnBatchUpdated);
            string[] id = String.IsNullOrEmpty(Request["TestId"]) ? null : Request["TestId"].Split(',');

            for (int i = 0; i < id.Length; i++)
            {
                test.Entity.Id = Convert.ToInt32(id[i]);
                test.Entity.Name = String.IsNullOrEmpty(Request["Name"]) ? "" : Request["Name"];
                test.Entity.Age = String.IsNullOrEmpty(Request["Age"]) ? 0 : Convert.ToInt32(Request["Age"]);
                test.Entity.Context = String.IsNullOrEmpty(Request["Context"]) ? "" : Request["Context"];
                if (!String.IsNullOrEmpty(Request["Pic"]))
                {
                    byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
                    test.Entity.Pic = pic;
                }
                //上面的第一次不用创建，从第二个实体开始就需要创建新实体了
                test.AppendEntity();
                test.CreateEntity();
            }
            if (test.UpdateBatch())
                ReturnResult("1");
            else
                ReturnResult("0");
        }
        catch (Exception e)
        {
            ReturnResult("0");
        }
    }

    void Test_OnBatchUpdated(Test sender, OPEvent arg)
    {
        string bid = arg.CurrBatchId;
    }

    private void ReturnResult(string str)
    {
        Response.Write(str);
        Response.End();
    }
}
