/// <reference path="jquery.intellisense.js"/>

$(document).ready(function() {

    //======= For UI ===========================================
    $('body').append('<div id="Loading"><b>请稍后，正在处理中...</b></div>');
    $('#Loading').hide();

    $("#SelectEntity > ul").tabs({ fx: { height: "toggle"} });

    $("#AddOne > ul").tabs({ fx: { height: "toggle"} }).bind('tabsselect', function(event, ui) {
        if (ui.index == 2) ShowGrid("AddOne-3", "list1", "pager1", "新增单实体后的Test表", "1=1");
        else RemoveGrid("AddOne-3");
    });
    $("#AddBatch > ul").tabs({ fx: { height: "toggle"} }).bind('tabsselect', function(event, ui) {
        if (ui.index == 2) ShowGrid("AddBatch-3", "list2", "pager2", "批量新增实体后的Test表", "1=1");
        else RemoveGrid("AddBatch-3");
    });

    $("#UpdateOne > ul").tabs({ fx: { height: "toggle"} }).bind('tabsselect', function(event, ui) {
        if (ui.index == 2) ShowGrid("UpdateOne-3", "list1", "pager1", "更新单实体后的Test表", "1=1");
        else RemoveGrid("UpdateOne-3");
    });
    $("#UpdateBatch > ul").tabs({ fx: { height: "toggle"} }).bind('tabsselect', function(event, ui) {
        if (ui.index == 2) ShowGrid("UpdateBatch-3", "list2", "pager2", "批量更新实体后的Test表", "1=1");
        else RemoveGrid("UpdateBatch-3");
    });

    $("#DeleteOne > ul").tabs({ fx: { height: "toggle"} }).bind('tabsselect', function(event, ui) {
        if (ui.index == 2) ShowGrid("DeleteOne-3", "list1", "pager1", "删除单实体后的Test表", "1=1");
        else RemoveGrid("DeleteOne-3");
    });
    $("#DeleteBatch > ul").tabs({ fx: { height: "toggle"} }).bind('tabsselect', function(event, ui) {
        if (ui.index == 2) ShowGrid("DeleteBatch-3", "list2", "pager2", "批量删除实体后的Test表", "1=1");
        else RemoveGrid("DeleteBatch-3");
    });

    $("#GridViewPager > ul").tabs({ fx: { height: "toggle"} });
    $("#GridViewPagerN > ul").tabs({ fx: { height: "toggle"} });
    $("#DataListPager > ul").tabs({ fx: { height: "toggle"} });
    $("#RepeaterPager > ul").tabs({ fx: { height: "toggle"} });
    $("#Dialog1 > ul").tabs({ fx: { height: "toggle"} });
    $("#Dialog2 > ul").tabs({ fx: { height: "toggle"} });
    $("#Dialog3 > ul").tabs({ fx: { height: "toggle"} });
    $("#Popup1 > ul").tabs({ fx: { height: "toggle"} });
    $("#Popup2 > ul").tabs({ fx: { height: "toggle"} });
    $("#Cloud1 > ul").tabs({ fx: { height: "toggle"} });
    $("#ListBuilder1 > ul").tabs({ fx: { height: "toggle"} });
    $("#pagestyle").slideToggle("slow");
    $("#ShowPageStyle").click(function() {
       $("#pagestyle").slideToggle("slow");
    });

    //======== For Event ========================================
    //查询实体
    $("#TestSelect").click(function() {
        var criteria = "1=1";
        if ($("#TestName").val() != "") criteria += " and name = '" + $("#TestName").val() + "'";
        if ($("#TestAge").val() != "") criteria += " and age = " + $("#TestAge").val();
        if ($("#TestContext").val() != "") criteria += " and context like '" + $("#TestContext").val() + "'";
        RemoveGrid("SelectResult");
        ShowGrid("SelectResult", "list", "pager", "Test表", criteria);
    });

    //单实体添加操作
    $("#TestAdd").click(function() {
        AddOneEntity();
    });

    //批量实体添加操作
    $("#TestAddBatch").click(function() {
        AddBatchEntity();
    });

    //单实更新操作
    $("#TestUpdate").click(function() {
        UpdateOneEntity();
    });

    //批量更新操作
    $("#TestUpdateBatch").click(function() {
        UpdateBatchEntity();
    });

    //单实删除操作
    $("#TestDelete").click(function() {
        DeleteOneEntity();
    });

    //批量删除操作
    $("#TestDeleteBatch").click(function() {
        DeleteBatchEntity();
    });

    //======== For Methods ========================================


    //单实体新增
    AddOneEntity = function() {
        ShowLoading();
        $.ajax({
            type: "POST",
            url: "Data_add.aspx",
            data: "Action=add&Name=" + $("#TestName").val() + "&Age=" + $("#TestAge").val() + "&Context=" + $("#TestContext").val() + "&Pic=" + $("#TestPic").val() + "&IsUse=" + $("#TestIsUse").val(),
            complete: function() { $.unblockUI(); },
            success: function(msg) {
                msg = msg.substring(0, 1);
                if (msg != "0")
                    ShowDialog("单实体新增操作", "恭喜，新增操作已成功！");
                else
                    ShowDialog("单实体新增操作", "抱歉，新增操作失败！");
            }
        });
    }

    //批量实体新增
    AddBatchEntity = function() {
        ShowLoading();
        $.ajax({
            type: "POST",
            url: "Data_add.aspx",
            data: "Action=addBatch&Name=" + $("#BTestName").val() + "&Age=" + $("#BTestAge").val() + "&Context=" + $("#BTestContext").val() + "&Pic=" + $("#BTestPic").val() + "&Count=" + $("#BTestCount").val(),
            complete: function() { $.unblockUI(); },
            success: function(msg) {
                msg = msg.substring(0, 1);
                if (msg != "0")
                    ShowDialog("批量实体新增操作", "恭喜，新增操作已成功！");
                else
                    ShowDialog("批量实体新增操作", "抱歉，新增操作失败！");
            }
        });
    }

    //单实体更新
    UpdateOneEntity = function() {
        ShowLoading();
        $.ajax({
            type: "POST",
            url: "Data_update.aspx",
            data: "Action=update&TestId=" + $("#TestId").val() + "&Name=" + $("#TestName").val() + "&Age=" + $("#TestAge").val() + "&Context=" + $("#TestContext").val() + "&Pic=" + $("#TestPic").val() + "&IsUse=" + $("#TestIsUse").val(),
            complete: function() { $.unblockUI(); },
            success: function(msg) {
                msg = msg.substring(0, 1);
                if (msg != "0")
                    ShowDialog("实体更新操作", "恭喜，更新操作已成功！");
                else
                    ShowDialog("实体更新操作", "抱歉，更新操作失败！");
            }
        });
    }

    //批量实体更新
    UpdateBatchEntity = function() {
        ShowLoading();
        $.ajax({
            type: "POST",
            url: "Data_update.aspx",
            data: "Action=updateBatch&TestId=" + $("#BTestId").val() + "&Name=" + $("#BTestName").val() + "&Age=" + $("#BTestAge").val() + "&Context=" + $("#BTestContext").val() + "&Pic=" + $("#BTestPic").val(),
            complete: function() { $.unblockUI(); },
            success: function(msg) {
                msg = msg.substring(0, 1);
                if (msg != "0")
                    ShowDialog("批量实体更新操作", "恭喜，更新操作已成功！");
                else
                    ShowDialog("批量实体更新操作", "抱歉，更新操作失败！");
            }
        });
    }

    //单实体删除
    DeleteOneEntity = function() {
        ShowLoading();
        $.ajax({
            type: "POST",
            url: "Data_delete.aspx",
            data: "Action=delete&TestId=" + $("#TestId").val(),
            complete: function() { $.unblockUI(); },
            success: function(msg) {
                msg = msg.substring(0, 1);
                if (msg != "0")
                    ShowDialog("实体删除操作", "恭喜，删除操作已成功！");
                else
                    ShowDialog("实体删除操作", "抱歉，删除操作失败！");
            }
        });
    }

    //批量实体删除
    DeleteBatchEntity = function() {
        ShowLoading();
        $.ajax({
            type: "POST",
            url: "Data_delete.aspx",
            data: "Action=deleteBatch&TestId=" + $("#BTestId").val(),
            complete: function() { $.unblockUI(); },
            success: function(msg) {
                msg = msg.substring(0, 1);
                if (msg != "0")
                    ShowDialog("批量实体删除操作", "恭喜，删除操作已成功！");
                else
                    ShowDialog("批量实体删除操作", "抱歉，删除操作失败！<br><font color='red'>请确定每个ID必须有效！</font>");
            }
        });
    }

    //======== For Controls ========================================

    //显示对话框
    ShowDialog = function(_title, _msg) {
        //对话框参数设置
        var _opacity = 0.5;
        var _width = "300";
        var _height = "200";
        var _minHeight = "180";
        var _minWidth = "280";
        var _css = "flora";
        var _modal = true;
        $('body').append('<div id="MsgBox"></div>');
        $('#MsgBox').html('<div class="icon"></div>' + _msg).css('display', 'block').dialog({
            title: _title,
            modal: _modal,
            overlay: { opacity: _opacity, background: 'black' },
            buttons: { ' 确 定 ': function() { $(this).dialog('destroy'); } },
            width: _width,
            height: _height,
            minHeight: _minHeight,
            minWidth: _minWidth,
            dialogClass: _css,
            resizable: false,
            close: function(event, ui) {
                $(this).dialog('destroy');
            }
        });
    }
    //显示数据列表
    ShowGrid = function(parentID, gridID, pagerID, title, criteria) {

        var toUrl = 'Data_select.aspx?action=GetGrid';

        $('#' + parentID).append('<table id="' + gridID + '" class="scroll" ></table><div id="' + pagerID + '" class="scroll" style="text-align:center;"></div>');

        $("#" + gridID).jqGrid({
            url: toUrl,
            datatype: 'xml',
            mtype: 'POST',
            colNames: ['ID', '名 称', '年 龄', '日 期', '是否使用', '内 容'],
            colModel: [
              { name: 'Id', index: 'Id', width: 55, align: 'center' },
              { name: 'Name', index: 'Name', width: 90, align: 'center', search: true },
              { name: 'Age', index: 'Age', width: 80, align: 'center' },
              { name: 'Datetime', index: 'Datetime', width: 100, align: 'center' },
              { name: 'Isuse', index: 'Isuse', width: 80, align: 'center' },
              { name: 'Context', index: 'Context', width: 200, sortable: false}],
            pager: $('#' + pagerID),
            rowNum: 10,
            rowList: [10, 15, 20],
            sortname: 'id|' + criteria,
            sortorder: 'asc',
            viewrecords: true,
            imgpath: 'css/Gridthemes/basic/images',
            caption: title,
            height: '185px'
            //multiselect: true
        }).navGrid('#' + pagerID, { add: false, del: false, edit: false, search: false, refresh: true, position: "right" });
    }

    RemoveGrid = function(parentID) {
        $('#' + parentID).empty();
    }
    //显示Loading
    ShowLoading = function() {

        $.blockUI({ message: $('#Loading'),
            css: {
                width: '208px',
                height: '15px',
                border: '0px',
                left: ($(window).width() - 100) / 2 + 'px',
                background: "url('images/loading.gif')"
            }
        });
    }
    //For SqlPager 
    setPageTo = function(paternalID, pageIndex) {
        $("#" + paternalID).block({
            message: $('#Loading'),
            css: {
                width: '208px',
                height: '15px',
                border: '0px',
                left: ($(window).width() - 100) / 2 + 'px',
                background: "url('images/loading.gif')"
            }
        });

        $.ajax({
            type: "POST",
            url: "SqlPager.aspx",
            data: "Action=sqlpager&paterID=" + paternalID + "&newIndex=" + pageIndex,
            complete: function() { $("#" + paternalID).unblock(); },
            success: function(result) {
                $("#" + paternalID).html(result);
            }
        });
    }

});

ChiliBook.lineNumbers = true;//高亮代码显示行数
