﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="ListBuilder.aspx.cs" Inherits="ListBuilderDemo"  %>
<%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="TagCloud" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
   <title>Winson.Framework_ListBuilder的使用</title>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="Title" Runat="Server">
   <h2>ListBuilder的使用</h2>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <h5>一、基本说明：</h5>
<p>
    ListBuilder是一个可在服务器端通过模板来动态创建 &lt;dt&gt; &lt;ul&gt; &lt;li&gt; 等标签的功能类<br />

  
    <h5>二、基本使用说明：</h5>
    
 创建一组ul标签，大家只要看看代码即知道如何使用了，代码如下：
<pre><code class="csharp">
//引用命名空间
using Winson.Framework.Utility;

ListBuilder lb1 = new ListBuilder();
ListBuilder lb2 = new ListBuilder("ul");

//设置模板
lb2.SetTemplate("&lt;a href=ListBuilder.aspx?tid={#id}" + "\" target=\"_blank\"&gt;{#title}&lt;/a&gt; &lt;span class='date'&gt;[{#date}]&lt;/span&gt;");

//为模板里添加数据，对应与以上模板各个变量
lb2.AddTemplateData("id", "2");
lb2.AddTemplateData("title", "Winson.Framework");
lb2.AddTemplateData("date", "2009-01-01");

//模板结束
lb2.EndTemplateData();

//将lb2添加到lb1中
lb1.AddTemplateData("lb2", lb2.ToString());

//为lb1设置模板
lb1.SetTemplate("&lt;a href=\"{#url}\" target=\"_blank\"&gt;&lt;strong&gt;{#sortName}&lt;/strong&gt;&lt;/a&gt;\r\n{#lb2}");
lb1.AddTemplateData("url", "http://www.szblogs.com");
lb1.AddTemplateData("sortName", "深圳博客网");
lb1.EndTemplateData();

//最后将创建好的标签输出即可
Label1.Text = lb1.ToString();
</code></pre>

<h5>三、效果演示：</h5>

<p><h4>以上代码所创建出来的效果如下：</h4><br />

<div id="ListBuilder1">

<ul style="height: 30px;"> <li><a href="#ListBuilder1-1"><span>　效  果　</span></a></li> 
</ul> 

<div id="ListBuilder1-1">
<asp:Label ID="Label1" runat="server" Text="Label"></asp:Label>&nbsp;
 </div> 
 </div>

</p>

</asp:Content>

