﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Log_event.aspx.cs" Inherits="Log_operate" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
<title>Winson.Framework功能演示_事务日志</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="Title" Runat="Server">
<h2>事务日志使用说明</h2>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<h5>一、基本说明：</h5>

<p>    事务日志可以记录网站相关操作，默认记录的内容主要有三项：<br />
1.事务名称，即当前操作(字段名：<span class="comment">EventName</span>)<br />
2.操作者(字段名：<span class="comment">User</span>)<br />
3.操作信息(字段名：<span class="comment">Msg</span>)<br />
以上三项默认对应表名为  <span class="comment">EventLog</span> 的数据库（如需不用表名，可自行修改web.config配置文件），即在使用事务日志时，必须先创建相应的数据表，里面需包括以上三个字段，同时还有一个创建日期字段，在此DEMO里已包括了相应的数据表
<br /><br />

以下是事务日志表的创建：

<pre>
<code class="sql">
CREATE TABLE [dbo].[EventLog] (
	[id] [int] IDENTITY (1, 1) NOT NULL PRIMARY KEY,
	[EventName] [nvarchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[User] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Msg] [nvarchar] (1000) COLLATE Chinese_PRC_CI_AS NULL ,
	[Createdate] [datetime] NOT NULL 
) ON [PRIMARY]
GO
</code>
</pre>

</p>

<h5>二、操作步骤：</h5>

 a.引用以下命名空间：
<pre>
<code class="csharp">using Winson.Framework.LogProviders;</code></pre>

b.在实现某操作方法时，调用日志处理方法 <span class="comment">OutputEventLog</span>，其中有3个参数，第一个为事务名称，即当前操作，第二个为操作者，第三个为操作信息，以下是完整代码，非常简单：
<pre><code class="csharp">
public void Add()
{
    //do some code...
    
    LogManage.OutputEventLog("增加操作","Winson","增加了一条日志记录");
}
</code></pre>


</asp:Content>

