﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using Winson.Framework.Controls;

public partial class Index : System.Web.UI.Page
{
    Dialog dialog;

    protected void Page_Load(object sender, EventArgs e)
    {
        //先禁止显示弹出框
        popupBob.Visible = popupWin2.Visible = popupWin.Visible = false;
        //也可在后台添加事件
        popupWin.PopupClosed += new EventHandler(popupWin_PopupClosed);
    }

    protected void btnPopup_Click(object sender, EventArgs e)
    {
        popupWin.HideAfter = (sender == null) ? -1 : 5000;
        popupWin.Visible = true;
        popupWin.Title = textTitle.Text;
        popupWin.Message = textMsg.Text;
        popupWin.Text = textFull.Text;
        popupWin.DragDrop = (dropDrag.SelectedIndex == 0);
        switch (popDocking.SelectedIndex)
        {
            case 0: popupWin.DockMode = PopupDocking.BottomLeft; break;
            case 1: popupWin.DockMode = PopupDocking.BottomRight; break;
        }
        switch (clrStyle.SelectedIndex)
        {
            case 0: popupWin.ColorStyle = PopupColorStyle.Red; break;
            case 1: popupWin.ColorStyle = PopupColorStyle.Green; break;
            case 2: popupWin.ColorStyle = PopupColorStyle.Blue; break;
            case 3: popupWin.ColorStyle = PopupColorStyle.Violet; break;
        }
        popupWin2.Visible = false;
    }

    protected void btn4Ever_Click(object sender, System.EventArgs e)
    {
        btnPopup_Click(null, null);
    }

    protected void btnTwo_Click(object sender, System.EventArgs e)
    {
        btnPopup_Click(sender, e);
        popupWin2.DockMode = popupWin.DockMode;
        popupWin2.DragDrop = (dropDrag.SelectedIndex == 0);
        popupWin2.Visible = true;
    }

    protected void btnBob_Click(object sender, System.EventArgs e)
    {
        popupBob.Visible = true;
        popupBob.DragDrop = (dropDrag.SelectedIndex == 0);
    }

    #region 弹出框控件的点击事件
    protected void popupWin2_LinkClick(object sender, System.EventArgs e)
    {
        dialog = new Dialog(this);
        dialog.ShowMsgBox("Hey ! 你点击第二个弹出窗口!!");
    }

    protected void popupWin_LinkClick(object sender, System.EventArgs e)
    {
        dialog = new Dialog(this);
        dialog.ShowMsgBox("Hey ! 你点击第一个弹出窗口!!");
    }

    protected void popupWin_PopupClosed(object sender, EventArgs e)
    {
        dialog = new Dialog(this);
        dialog.ShowMsgBox("Hey ! 你关闭了第一个弹出窗口!!");
    }

    protected void popupWin2_PopupClose(object sender, EventArgs e)
    {
        dialog = new Dialog(this);
        dialog.ShowMsgBox("Hey ! 你关闭了第二个弹出窗口!!");
    }
    #endregion

    #region 使用钩子的事件
    protected void btnSetProp_Click(object sender, EventArgs e)
    {
        showTest.NewMessage = NewMsg.Text;
        showTest.NewText = NewText.Text;
        showTest.NewTitle = NewTitle.Text;
        helpFirst.NewMessage = textFirst.Text;
        helpFirst.NewText = textFirst.Text;
        helpSecond.NewMessage = textSecond.Text;
        helpSecond.NewText = textSecond.Text;
    }
    #endregion
}
