﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="SessionHelper.aspx.cs" Inherits="SessionHelperDemo"  %>
<%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="TagCloud" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
   <title>Winson.Framework_SessionHelper的使用</title>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="Title" Runat="Server">
   <h2>SessionHelper的使用</h2>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <h5>一、基本说明：</h5>
<p>
    SessionHelper是一个方便操作Session的类，通过此类，可以完成对Session的增、删、取等操作，同时还可以设置Session的作用域等，由于里面的方法比较多，在此我只简单地说明主要的用法，其余的大家可自行打开 <span class="parm">Utility/SessionHelper.cs</span> 文件查看，里面每一函数都已有注释的了<br />
 
  
    <h5>二、基本使用说明：</h5>
    
1、添加Session：<br /> 
 将对象添加到指定的Session里，并指定类型和作用域，代码如下：
<pre><code class="csharp">
//引用命名空间
using Winson.Framework.Utility;

//SessionHelper.Scope.Global 为此Session的作用域，枚举类型
//"MySession"                为此Session的类型，如可自定义此Session属于哪个功能模块   
//_sessionKey                对应的key值，在获取时要使用此key来获取
//_object                    为要放到Session的对象
SessionHelper.Add(SessionHelper.Scope.Global,"MySession",_sessionKey, _object);

//此方法有6个重载，分别可以设置cache的过期时间、文件依赖等
</code></pre>


2、获取Session：<br /> 
 在Session里获取指定作用域和类型的对象，代码如下：
<pre><code class="csharp">
//引用命名空间
using Winson.Framework.Utility;

//SessionHelper.Scope.Global 为此Session的作用域，枚举类型
//"MySession"                为此Session的类型，如可自定义此Session属于哪个功能模块   
//_sessionKey                对应的key值，在获取时要使用此key来获取
SessionHelper.Get(SessionHelper.Scope.Global, "MySession", _sessionKey);
</code></pre>

3、删除Session：<br /> 
 删除Session里相应的对象，代码如下：
<pre><code class="csharp">
//引用命名空间
using Winson.Framework.Utility;

//删除Session有以下三种方式

SessionHelper.Clear();//删除所有Session

SessionHelper.ClearCategory("MySession");//只删除指定类型里的所有Session

SessionHelper.ClearScope(SessionHelper.Scope.Global);//只删除指定范围里的所有Session
</code></pre>
</p>

</asp:Content>

