﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="SqlPager.aspx.cs" Inherits="SqlPagerDemo" EnableEventValidation="false"%>
<%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="SqlPager" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
<title>Winson.Framework功能演示_SqlPager分页控件</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="Title" Runat="Server">
<h2>SqlPager分页控件使用说明</h2>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<h5>一、基本说明：</h5>

<p>SqlPager是一个基于PagedDataSource的分页控件，此控件有丰富的参数设置，可让用户灵活应对各种情况，现在的功能已算是比较完善的了<br />
<br />
主要功能及特性如下：
<div class="list">
<ul>
<li>支持多达11种自定义样式显示</li>
<li>支持多个数据库容器分页，其中包括 <span class="comment">GridView、Repeater、DataList</span> 等控件。</li>
<li>支持AJAX分页</li>
<li>已可在同一页面同时使用多个SqlPager控件</li>
<li>支持在母板页里使用</li>
<li>使用缓存技术以提高分页效率</li>
<li>可直接使用SQL语句获取数据源</li>
<li>可使用自定义数据源</li>
<li>可完全自定义分页按钮样式，支持图片按钮</li>
<li>支持排序字段设置和相应的反序方式</li>
</ul>
</div>


<h5>二、属性说明：</h5>
以下将详细介绍各种属性：(<span class="comment">只介绍主要的属性设置</span>)
<div class="detail">
<span class="title">a.界面相关</span><br /><br />
<ul>
<li>
<span class="parm">BorderStyle:</span>设置分页控件边框样式
</li>
<li>
<span class="parm">BorderWidth:</span>设置分页控件边框宽度
</li>
<li>
<span class="parm">ShowCount:</span>显示统计页数模式,0:'第{0}页/总{1}页'  1:'第{0}页/总{1}页 [每页{2}条/共{3}条记录]'    2:'不显示'
</li>
<li>
<span class="parm">ButtonAndTextBoxVisible:</span>获取或设置转到文本框和按钮是否显示，默认为True(只对NumPager样式有效)
</li>
<li>
<span class="parm" style="cursor:hand" id="ShowPageStyle">PagerStyle:</span>设置要显示的样式类型，分别有以下11(点击展开)类：<br />
<pre id="pagestyle"><code class="csharp">
/// &lt;summary&gt;
/// 页面样式设置
/// &lt;/summary&gt;
public enum PagerStyle
{
	/// &lt;summary&gt;
	/// 按钮样式为上下页箭头
	/// &lt;/summary&gt;
	NextPrev,
	/// &lt;summary&gt;
	/// 按钮样式来下拉框页码
	/// &lt;/summary&gt;
	NumericPages,
	/// &lt;summary&gt;
	/// 按钮和下拉框页码一起显示
	/// &lt;/summary&gt;
	NextAndNumeric,
	/// &lt;summary&gt;
	/// 自定义样式，可自定文本
	/// &lt;/summary&gt;
	CustomStyle,
	/// &lt;summary&gt;
	/// 自定义样式，可自定文本，同时显示下拉页码
	/// &lt;/summary&gt;
	CustomAndNumeric,
	/// &lt;summary&gt;
	/// 无刷新箭头式按钮
	/// &lt;/summary&gt;
	AjaxNext,
	/// &lt;summary&gt;
	/// 无刷新箭头式按钮加下拉页码
	/// &lt;/summary&gt;
	AjaxNextAndNum,
	/// &lt;summary&gt;
	/// 无刷新下拉框按钮
	/// &lt;/summary&gt;
	AjaxNumeric,
	/// &lt;summary&gt;
	/// 自定义无刷新分页
	/// &lt;/summary&gt;
	AjaxCustomPages,
	/// &lt;summary&gt;
	/// 自定义无刷新和下拉框页码
	/// &lt;/summary&gt;
	AjaxCustomAndNumeric,
	/// &lt;summary&gt;
	/// 数字页码样式
	/// &lt;/summary&gt;
	NumPager，
	/// &lt;summary&gt;
	/// 使用自定义CSS产生的数字页码样式 （新）
	/// &lt;/summary&gt;
    NumPagerWithCSS
}
</code>
</pre>
</li>

</ul>

<br /><br />
<span class="title">b.页码按钮样式相关</span><br /><br />
<ul>
<li>
<span class="parm">FirstButton:</span>获取或设置第一页的文字或图片地址,默认为“第一页”
</li>
<li>
<span class="parm">PrveButton:</span>获取或设置上一页的文字或图片地址,默认为“上一页”
</li>
<li>
<span class="parm">NextButton:</span>获取或设置下一页的文字或图片地址,默认为“下一页”
</li>
<li>
<span class="parm">LastButton:</span>获取或设置最后一页的文字或图片地址,默认为“最后第一页”
</li>
<li>
<span class="parm">LinkTextCssClass:</span>获取或设置链接文字或图片地址的CSS类名(只对NumPager样式有效)
</li>
<li>
<span class="parm">CurrentNumberColor:</span>获取或设置当前连接数字的颜色(只对NumPager样式有效)
</li>
<li>
<span class="parm">LeftPageSize:</span>设置或获取分页左边要显示的页码数，默认为5(只对NumPager样式有效)
</li>
<li>
<span class="parm">RightPageSize:</span>设置或获取分页右边要显示的页码数，默认为5(只对NumPager样式有效)
</li>
<li>
<span class="parm">LinkNumberWidth:</span>设置或获取连接数字单元格的宽度，默认为16px(只对NumPager样式有效)
</li>
<li>
<span class="parm">LinkNumberHeight:</span>设置或获取连接数字单元格的高度，默认为16px(只对NumPager样式有效)
</li>
<li>
<span class="parm">ButtonText:</span>获取或设置转到按钮文本或图片(只对NumPager样式有效)
</li>
<li>
<span class="parm">ButtonType:</span>获取或设置转到按钮类型。可以为：ButtonType.Button，ButtonType.Image。(只对NumPager样式有效)
</li>
<li>
<span class="parm">TextBoxWidth:</span>获取或设置文本框宽度，默认为4(只对NumPager样式有效)
</li>
<li>
<span class="new">(3.3 new)</span><span class="parm">PaterElementID:</span>分页控件所在元素的ID,以此ID来设置分页样式(只对NumPagerWithCSS样式有效)
</li>
</ul>

<br /><br />
<span class="title">c.数据源相关</span><br /><br />
<ul>
<li>
<span class="parm">ControlToPaginate:</span>绑定的数据容器控件ID
</li>
<li>
<span class="parm">ContentPlaceHolderID:</span>所在当前母板页ID(如不使用母板页,则不需设置)
</li>
<li>
<span class="parm">PaternalID:</span>分页控件所在父级元素ID,如DIV等元素
</li>
<li>
<span class="parm">ItemsPerPage:</span>每页显示记录数
</li>
<li>
<span class="parm">ToolTip:</span>在使用数字页码样式(NumPager)时,鼠标放上去时显示的提示文本
</li>
<li>
<span class="parm">UseCustomDataSource:</span>是否使用自定义数据源,值为true/false
</li>
<li>
<span class="parm">CustomDataSource:</span>指定自定义数据源,DataSet类型
</li>
<li>
<span class="parm">SelectCommand:</span>设置SQL查询语句,使用此属性,必须将UseCustomDataSource设为false
</li>
<li>
<span class="parm">SortField:</span>排序字段
</li>
<li>
<span class="parm">SortStyle:</span>排序方式,枚举类型SortStyle.DESC/SortStyle.ASC
</li>
<li>
<span class="parm">CacheDuration:</span>设置缓存的持续时间，默认为60秒
</li>
<li>
<span class="new">(3.3 new)</span><span class="parm">ClientSetPager:</span>设置客户端的分页函数,for AJAX,但必须实现2个参数,如 setPageTo = function(paternalID, pageIndex),分页控件所在的父控件ID,一般是所在的DIV的ID,另一个是当前页数,具体实现看本站示例
</li>
</ul>
</div>

<h5>三、使用说明：</h5>

SqlPager使用其实很简单，只需在页面添加相应的控件代码，然后在后台进行绑定调用就可以了，只是如果要使用AJAX，还就需添加一些JS代码，以下是使用的步骤：<br /><br />

1.添加HTML前台控件代码，关于控件属性设置，请参照上述部分：
<pre><code class="html">
&lt;!--在页面顶部添加控件的引用--&gt;
&lt;%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="SqlPager" %&gt;


&lt;div id="GridViewShow"&gt;
    &lt;asp:GridView ID="GridView1" runat="server" Width="600" EnableViewState="False" AutoGenerateColumns="False"
      CellPadding="4" ForeColor="#333333" GridLines="None"&gt;
       &lt;Columns&gt;
			&lt;asp:BoundField DataField="ID" HeaderText="ID" /&gt;
			&lt;asp:BoundField DataField="Name" HeaderText="姓名" /&gt;
			&lt;asp:BoundField DataField="Age" HeaderText="年龄" /&gt;
			&lt;asp:BoundField DataField="Datetime" HeaderText="日期" /&gt;
       &lt;/Columns&gt;
		&lt;FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" /&gt;
		&lt;RowStyle BackColor="#F7F6F3" ForeColor="#333333" /&gt;
		&lt;EditRowStyle BackColor="#999999" /&gt;
		&lt;SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" /&gt;
		&lt;PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" /&gt;
		&lt;HeaderStyle BackColor="#3366FF" Font-Bold="True" ForeColor="White" /&gt;
		&lt;AlternatingRowStyle BackColor="White" ForeColor="#284775" /&gt;
	&lt;/asp:GridView&gt;
	&lt;br /&gt;
	&lt;SqlPager:SqlPager ID="SqlPager1" runat="server" Width="600" ControlToPaginate="GridView1" ItemsPerPage="10" BorderStyle="None" ShowCount="1" BackColor="#ffffff" PagerStyle="AjaxCustomAndNumeric"   BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaternalID="GridViewShow" &gt;&lt;/SqlPager:SqlPager&gt;
&lt;/div&gt;
</code></pre><br />
2.添加JS代码以实现AJAX分页：<br />
主要是实现 <span class="comment">setPageTo(paternalID, pageIndex)</span> 方法，以下是结合了jQuery一起实现的AJAX，你也可以自行去实现此方法，只是有2个参数要分别传入后台处理的
<pre><code class="js">
//paternalID 为分页控件所在的父级元素ID
//pageIndex 为当前所在页面
setPageTo = function(paternalID, pageIndex){
	 $("#"+paternalID).block({  
			message: $('#Loading'),
	   css: {                
				width: '208px' ,
				height:'15px' ,
				border: '0px',
				left: ($(window).width() -100) /2 + 'px',
				background: "url('images/loading.gif')"				
			}  
		}); 

	 $.ajax({
	   type: "POST",
	   url: "SqlPager.aspx",
	   data: "Action=sqlpager&paterID="+paternalID+"&newIndex="+pageIndex,
	   complete: function(){$("#"+paternalID).unblock();},
	   success: function(result){
			$("#"+paternalID).html(result);		   
	   }
	 });
}
</code></pre>
3.添加后台数据处理代码：<br />
<pre><code class="csharp">
Test test = new Test();
//NameValueCollection conditionValue = new NameValueCollection();
//conditionValue["name like"] = "sdf";
//DataSet testds = test.GetDataSet(conditionValue);//可添加条件获取
DataSet testds = test.GetDataSet(null);//获取全部数据直接用null

//绑定分页控件
SqlPager1.UseCustomDataSource = true;
SqlPager1.CustomDataSource = testds;
SqlPager1.DataBind();

//使用AJAX分页，返回数据并显示
private void PageChange1()
{
	int newPageIndex = Convert.ToInt32(Request["newIndex"]);
	SqlPager1.GoToPage(newPageIndex);
	StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
	HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

	if (GridView1 != null)
	{
		GridView1.Visible = true;
		GridView1.RenderControl(writer2);
	}
	SqlPager1.RenderControl(writer2);
	writer2.Flush();
	writer2.Close();
	Response.Write(writer1.ToString());
	Response.End();
}
</code></pre>

经过以上3步设置，就可以使用SqlPager分页控件了。<br />

<form id="form1" runat="server">

<h5>四、效果演示：</h5>

<P class="comment">注：以下演示均以WinsonFrameDB数据库的 Test 表为例:</P>

<p><h4>1、GridView分页：</h4><br />

<div id="GridViewPager">

<ul style="height: 30px;"> <li><a href="#GridViewPager-1"><span>　演　示　</span></a></li> <li><a href="#GridViewPager-2"><span>　源　码　</span></a></li>

</ul> 

<div id="GridViewPager-1">

<div id="GridViewShow">
            <asp:GridView ID="GridView1" runat="server" Width="600" EnableViewState="False" AutoGenerateColumns="False"
                CellPadding="4" ForeColor="#333333" GridLines="None">
                <Columns>
                    <asp:BoundField DataField="ID" HeaderText="ID" />
                    <asp:BoundField DataField="Name" HeaderText="姓名" />
                    <asp:BoundField DataField="Age" HeaderText="年龄" />
                    <asp:BoundField DataField="Datetime" HeaderText="日期" />
                </Columns>
                <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
                <EditRowStyle BackColor="#999999" />
                <SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" />
                <PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" />
                <HeaderStyle BackColor="#3366FF" Font-Bold="True" ForeColor="White" />
                <AlternatingRowStyle BackColor="White" ForeColor="#284775" />
            </asp:GridView>
            <br />
            <SqlPager:SqlPager ID="SqlPager1" runat="server"   Width="600" ControlToPaginate="GridView1" 
            ItemsPerPage="10" BorderStyle="None" ShowCount="1" BackColor="#ffffff" PagerStyle="AjaxCustomAndNumeric"   
            BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaternalID="GridViewShow" ></SqlPager:SqlPager>
            <br />
        </div>  
 
 </div> 
 
<div id="GridViewPager-2"> 
前台HTML代码：
<pre><code class="html">
&lt;!--在页面顶部添加控件的引用--&gt;
&lt;%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="SqlPager" %&gt;

&lt;div id="GridViewShow"&gt;
    &lt;asp:GridView ID="GridView1" runat="server" Width="600" EnableViewState="False" AutoGenerateColumns="False"
      CellPadding="4" ForeColor="#333333" GridLines="None"&gt;
       &lt;Columns&gt;
			&lt;asp:BoundField DataField="ID" HeaderText="ID" /&gt;
			&lt;asp:BoundField DataField="Name" HeaderText="姓名" /&gt;
			&lt;asp:BoundField DataField="Age" HeaderText="年龄" /&gt;
			&lt;asp:BoundField DataField="Datetime" HeaderText="日期" /&gt;
       &lt;/Columns&gt;
		&lt;FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" /&gt;
		&lt;RowStyle BackColor="#F7F6F3" ForeColor="#333333" /&gt;
		&lt;EditRowStyle BackColor="#999999" /&gt;
		&lt;SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" /&gt;
		&lt;PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" /&gt;
		&lt;HeaderStyle BackColor="#3366FF" Font-Bold="True" ForeColor="White" /&gt;
		&lt;AlternatingRowStyle BackColor="White" ForeColor="#284775" /&gt;
	&lt;/asp:GridView&gt;
	&lt;br /&gt;
	&lt;SqlPager:SqlPager ID="SqlPager1" runat="server" Width="600" ControlToPaginate="GridView1" ItemsPerPage="10" BorderStyle="None" ShowCount="1" BackColor="#ffffff" PagerStyle="AjaxCustomAndNumeric"   BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaternalID="GridViewShow" &gt;&lt;/SqlPager:SqlPager&gt;
&lt;/div&gt;
</code></pre>

前台JS代码：
<pre><code class="js">
//paternalID 为分页控件所在的父级元素ID
//pageIndex 为当前所在页面
setPageTo = function(paternalID, pageIndex){
	 $("#"+paternalID).block({  
			message: $('#Loading'),
	   css: {                
				width: '208px' ,
				height:'15px' ,
				border: '0px',
				left: ($(window).width() -100) /2 + 'px',
				background: "url('images/loading.gif')"				
			}  
		}); 

	 $.ajax({
	   type: "POST",
	   url: "SqlPager.aspx",
	   data: "Action=sqlpager&paterID="+paternalID+"&newIndex="+pageIndex,
	   complete: function(){$("#"+paternalID).unblock();},
	   success: function(result){
			$("#"+paternalID).html(result);		   
	   }
	 });
}
</code></pre>

后台代码：
<pre><code class="csharp">
Test test = new Test();
//NameValueCollection conditionValue = new NameValueCollection();
//conditionValue["name like"] = "sdf";
//DataSet testds = test.GetDataSet(conditionValue);//可添加条件获取
DataSet testds = test.GetDataSet(null);//获取全部数据直接用null

//绑定分页控件
SqlPager1.UseCustomDataSource = true;
SqlPager1.CustomDataSource = testds;
SqlPager1.DataBind();

//使用AJAX分页，返回数据并显示
private void PageChange1()
{
	int newPageIndex = Convert.ToInt32(Request["newIndex"]);
	SqlPager1.GoToPage(newPageIndex);
	StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
	HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

	if (GridView1 != null)
	{
		GridView1.Visible = true;
		GridView1.RenderControl(writer2);
	}
	SqlPager1.RenderControl(writer2);
	writer2.Flush();
	writer2.Close();
	Response.Write(writer1.ToString());
	Response.End();
}
</code></pre>

 </div> 
 
</div>



<p><h4>2、DataList分页：</h4><br />

<div id="DataListPager">

<ul style="height: 30px;"> <li><a href="#DataListPager-1"><span>　演　示　</span></a></li> <li><a href="#DataListPager-2"><span>　源　码　</span></a></li>

</ul> 

<div id="DataListPager-1">

<div id="DataListShow">            
            <asp:DataList ID="DataList1" runat="server" BackColor="White" 
        BorderColor="#E7E7FF" BorderStyle="None" BorderWidth="1px" CellPadding="3" 
        GridLines="Horizontal"  RepeatColumns="5">        
                <FooterStyle BackColor="#B5C7DE" ForeColor="#4A3C8C" />
                <AlternatingItemStyle BackColor="#F7F7F7" />
                <ItemStyle BackColor="#E7E7FF" ForeColor="#4A3C8C" />
                <SelectedItemStyle BackColor="#738A9C" Font-Bold="True" ForeColor="#F7F7F7" />
                <HeaderStyle BackColor="#4A3C8C" Font-Bold="True" ForeColor="#F7F7F7" />
                <ItemTemplate>
ID:<%#DataBinder.Eval(Container.DataItem, "id" )%><br />
姓名:<%#DataBinder.Eval(Container.DataItem, "name" )%><br />
年龄:<%#DataBinder.Eval(Container.DataItem, "age" )%><br />
日期:<%#DataBinder.Eval(Container.DataItem, "Datetime")%><br />
</ItemTemplate>
    </asp:DataList>           
            <br />
            <SqlPager:SqlPager ID="SqlPager2" runat="server" Width="600" ControlToPaginate="DataList1" ItemsPerPage="10" BorderStyle="None" ShowCount="2" BackColor="#ffffff" PagerStyle="NumPager"  BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaternalID="DataListShow" ></SqlPager:SqlPager>
            <br />
        </div>  
 
 </div> 
 
<div id="DataListPager-2"> 

前台HTML代码：
<pre><code class="html">
&lt;div id="DataListShow"&gt;            
     &lt;asp:DataList ID="DataList1" runat="server" BackColor="White" 
        BorderColor="#E7E7FF" BorderStyle="None" BorderWidth="1px" CellPadding="3" 
        GridLines="Horizontal"  RepeatColumns="5"&gt;        
                &lt;FooterStyle BackColor="#B5C7DE" ForeColor="#4A3C8C" /&gt;
                &lt;AlternatingItemStyle BackColor="#F7F7F7" /&gt;
                &lt;ItemStyle BackColor="#E7E7FF" ForeColor="#4A3C8C" /&gt;
                &lt;SelectedItemStyle BackColor="#738A9C" Font-Bold="True" ForeColor="#F7F7F7" /&gt;
                &lt;HeaderStyle BackColor="#4A3C8C" Font-Bold="True" ForeColor="#F7F7F7" /&gt;
                &lt;ItemTemplate&gt;
				ID:&lt;%#DataBinder.Eval(Container.DataItem, "id" )%&gt;&lt;br /&gt;
				姓名:&lt;%#DataBinder.Eval(Container.DataItem, "name" )%&gt;&lt;br /&gt;
				年龄:&lt;%#DataBinder.Eval(Container.DataItem, "age" )%&gt;&lt;br /&gt;
				日期:&lt;%#DataBinder.Eval(Container.DataItem, "Datetime")%&gt;&lt;br /&gt;
				&lt;/ItemTemplate&gt;
    &lt;/asp:DataList&gt;           
    &lt;br /&gt;
    &lt;SqlPager:SqlPager ID="SqlPager2" runat="server" Width="600" ControlToPaginate="DataList1" ItemsPerPage="10" BorderStyle="None" ShowCount="2" BackColor="#ffffff" PagerStyle="NumPager"   BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaternalID="DataListShow" &gt;&lt;/SqlPager:SqlPager&gt;
&lt;/div&gt;
</code></pre>

前台JS代码：
<pre><code class="js">
//paternalID 为分页控件所在的父级元素ID
//pageIndex 为当前所在页面
setPageTo = function(paternalID, pageIndex){
	 $("#"+paternalID).block({  
			message: $('#Loading'),
	   css: {                
				width: '208px' ,
				height:'15px' ,
				border: '0px',
				left: ($(window).width() -100) /2 + 'px',
				background: "url('images/loading.gif')"				
			}  
		}); 

	 $.ajax({
	   type: "POST",
	   url: "SqlPager.aspx",
	   data: "Action=sqlpager&paterID="+paternalID+"&newIndex="+pageIndex,
	   complete: function(){$("#"+paternalID).unblock();},
	   success: function(result){
			$("#"+paternalID).html(result);		   
	   }
	 });
}
</code></pre>

后台代码：
<pre><code class="csharp">
Test test = new Test();
//NameValueCollection conditionValue = new NameValueCollection();
//conditionValue["name like"] = "sdf";
//DataSet testds = test.GetDataSet(conditionValue);//可添加条件获取
DataSet testds = test.GetDataSet(null);//获取全部数据直接用null

//绑定分页控件
SqlPager2.UseCustomDataSource = true;
SqlPager2.CustomDataSource = testds;
SqlPager2.DataBind();

//使用AJAX分页，返回数据并显示
private void PageChange2()
{
	int newPageIndex = Convert.ToInt32(Request["newIndex"]);
	SqlPager2.GoToPage(newPageIndex);
	StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
	HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

	if (DataList1 != null)
	{
		DataList1.Visible = true;
		DataList1.RenderControl(writer2);
	}
	SqlPager2.RenderControl(writer2);
	writer2.Flush();
	writer2.Close();
	Response.Write(writer1.ToString());
	Response.End();
}
</code></pre>

 </div> 
 
</div>

<p><h4>3、Repeater分页：</h4><br />

<div id="RepeaterPager">

<ul style="height: 30px;"> <li><a href="#RepeaterPager-1"><span>　演　示　</span></a></li> <li><a href="#RepeaterPager-2"><span>　源　码　</span></a></li>

</ul> 

<div id="RepeaterPager-1">

<div id="RepeaterShow">
            
           <asp:Repeater ID="Repeater1" runat="server">
             <ItemTemplate>
            ID:<%#DataBinder.Eval(Container.DataItem, "id" )%><br />
姓名:<%#DataBinder.Eval(Container.DataItem, "name" )%><br />
年龄:<%#DataBinder.Eval(Container.DataItem, "age" )%><br />
日期:<%#DataBinder.Eval(Container.DataItem, "Datetime")%><br />
            </ItemTemplate>
            </asp:Repeater>
            
            <br />
            
            <SqlPager:SqlPager ID="SqlPager3" runat="server" Width="600" ControlToPaginate="Repeater1" ItemsPerPage="5" BorderStyle="None" ShowCount="1" BackColor="#ffffff" PagerStyle="AjaxCustomPages"  BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaternalID="RepeaterShow" ></SqlPager:SqlPager>
            <br />
        </div>  
 
 </div> 
 
<div id="RepeaterPager-2"> 


前台HTML代码：
<pre><code class="html">
&lt;div id="RepeaterShow"&gt;            
    &lt;asp:Repeater ID="Repeater1" runat="server"&gt;
             &lt;ItemTemplate&gt;
            ID:&lt;%#DataBinder.Eval(Container.DataItem, "id" )%&gt;&lt;br /&gt;
			姓名:&lt;%#DataBinder.Eval(Container.DataItem, "name" )%&gt;&lt;br /&gt;
			年龄:&lt;%#DataBinder.Eval(Container.DataItem, "age" )%&gt;&lt;br /&gt;
			日期:&lt;%#DataBinder.Eval(Container.DataItem, "Datetime")%&gt;&lt;br /&gt;
            &lt;/ItemTemplate&gt;
    &lt;/asp:Repeater&gt;            
	&lt;br /&gt;            
	&lt;SqlPager:SqlPager ID="SqlPager3" runat="server" Width="600" ControlToPaginate="Repeater1" ItemsPerPage="5" BorderStyle="None" ShowCount="1" BackColor="#ffffff" PagerStyle="AjaxCustomPages"   BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaternalID="RepeaterShow" &gt;&lt;/SqlPager:SqlPager&gt;
&lt;/div&gt;  
</code></pre>

前台JS代码：
<pre><code class="js">
//paternalID 为分页控件所在的父级元素ID
//pageIndex 为当前所在页面
setPageTo = function(paternalID, pageIndex){
	 $("#"+paternalID).block({  
			message: $('#Loading'),
	   css: {                
				width: '208px' ,
				height:'15px' ,
				border: '0px',
				left: ($(window).width() -100) /2 + 'px',
				background: "url('images/loading.gif')"				
			}  
		}); 

	 $.ajax({
	   type: "POST",
	   url: "SqlPager.aspx",
	   data: "Action=sqlpager&paterID="+paternalID+"&newIndex="+pageIndex,
	   complete: function(){$("#"+paternalID).unblock();},
	   success: function(result){
			$("#"+paternalID).html(result);		   
	   }
	 });
}
</code></pre>

后台代码：
<pre><code class="csharp">
Test test = new Test();
//NameValueCollection conditionValue = new NameValueCollection();
//conditionValue["name like"] = "sdf";
//DataSet testds = test.GetDataSet(conditionValue);//可添加条件获取
DataSet testds = test.GetDataSet(null);//获取全部数据直接用null

//绑定分页控件
SqlPager3.UseCustomDataSource = true;
SqlPager3.CustomDataSource = testds;
SqlPager3.DataBind();

//使用AJAX分页，返回数据并显示
private void PageChange3()
{
	int newPageIndex = Convert.ToInt32(Request["newIndex"]);
	SqlPager3.GoToPage(newPageIndex);
	StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
	HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

	if (Repeater1 != null)
	{
		Repeater1.Visible = true;
		Repeater1.RenderControl(writer2);
	}
	SqlPager3.RenderControl(writer2);
	writer2.Flush();
	writer2.Close();
	Response.Write(writer1.ToString());
	Response.End();
}
</code></pre>

 </div> 
 
</div>

<p><h4>4、GridView分页(<span class="new">3.3新样式演示</span>)：</h4><br />
主要演示3.3新版的分页按钮样式
<div id="GridViewPagerN">

<ul style="height: 30px;"> <li><a href="#GridViewPagerN-1"><span>　演　示　</span></a></li> <li><a href="#GridViewPagerN-2"><span>　源　码　</span></a></li>

</ul> 

<div id="GridViewPagerN-1">

<div id="GridViewShow2">
            <asp:GridView ID="GridView2" runat="server" Width="600" EnableViewState="False" AutoGenerateColumns="False"
                CellPadding="4" ForeColor="#333333" GridLines="None">
                <Columns>
                    <asp:BoundField DataField="ID" HeaderText="ID" />
                    <asp:BoundField DataField="Name" HeaderText="姓名" />
                    <asp:BoundField DataField="Age" HeaderText="年龄" />
                    <asp:BoundField DataField="Datetime" HeaderText="日期" />
                </Columns>
                <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
                <EditRowStyle BackColor="#999999" />
                <SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" />
                <PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" />
                <HeaderStyle BackColor="#3366FF" Font-Bold="True" ForeColor="White" />
                <AlternatingRowStyle BackColor="White" ForeColor="#284775" />
            </asp:GridView>
            <br />
           
             <SqlPager:SqlPager ID="SqlPager4" runat="server" Width="630" ControlToPaginate="GridView2"
             BorderStyle="None" BackColor="#ffffff" PagerStyle="NumPagerWithCSS" LeftPageSize=2 RightPageSize=2
            BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaterElementID="pagination-flickr" 
            PaternalID="GridViewShow2"></SqlPager:SqlPager>
            <br />
        </div>  
 
 </div> 
 
<div id="GridViewPagerN-2"> 
前台HTML代码：
<pre><code class="html">
&lt;!--在页面顶部添加控件的引用--&gt;
&lt;%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="SqlPager" %&gt;

&lt;div id="GridViewShow"&gt;
    &lt;asp:GridView ID="GridView1" runat="server" Width="600" EnableViewState="False" AutoGenerateColumns="False"
      CellPadding="4" ForeColor="#333333" GridLines="None"&gt;
       &lt;Columns&gt;
			&lt;asp:BoundField DataField="ID" HeaderText="ID" /&gt;
			&lt;asp:BoundField DataField="Name" HeaderText="姓名" /&gt;
			&lt;asp:BoundField DataField="Age" HeaderText="年龄" /&gt;
			&lt;asp:BoundField DataField="Datetime" HeaderText="日期" /&gt;
       &lt;/Columns&gt;
		&lt;FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" /&gt;
		&lt;RowStyle BackColor="#F7F6F3" ForeColor="#333333" /&gt;
		&lt;EditRowStyle BackColor="#999999" /&gt;
		&lt;SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" /&gt;
		&lt;PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" /&gt;
		&lt;HeaderStyle BackColor="#3366FF" Font-Bold="True" ForeColor="White" /&gt;
		&lt;AlternatingRowStyle BackColor="White" ForeColor="#284775" /&gt;
	&lt;/asp:GridView&gt;
	&lt;br /&gt;
	&lt;SqlPager:SqlPager ID="SqlPager4" runat="server" Width="600" ControlToPaginate="rptShowContent"
             BorderStyle="None" BackColor="#ffffff" PagerStyle="NumPagerWithCSS" LeftPageSize=2 RightPageSize=2
            BorderWidth="0" ContentPlaceHolderID="ContentPlaceHolder1" PaterElementID="pagination-flickr" 
            PaternalID="left" &gt;&lt;/SqlPager:SqlPager&gt;
&lt;/div&gt;
</code></pre>

前台JS代码：
<pre><code class="js">
//paternalID 为分页控件所在的父级元素ID
//pageIndex 为当前所在页面
setPageTo = function(paternalID, pageIndex){
	 $("#"+paternalID).block({  
			message: $('#Loading'),
	   css: {                
				width: '208px' ,
				height:'15px' ,
				border: '0px',
				left: ($(window).width() -100) /2 + 'px',
				background: "url('images/loading.gif')"				
			}  
		}); 

	 $.ajax({
	   type: "POST",
	   url: "SqlPager.aspx",
	   data: "Action=sqlpager&paterID="+paternalID+"&newIndex="+pageIndex,
	   complete: function(){$("#"+paternalID).unblock();},
	   success: function(result){
			$("#"+paternalID).html(result);		   
	   }
	 });
}
</code></pre>

后台代码：
<pre><code class="csharp">
Test test = new Test();
//NameValueCollection conditionValue = new NameValueCollection();
//conditionValue["name like"] = "sdf";
//DataSet testds = test.GetDataSet(conditionValue);//可添加条件获取
DataSet testds = test.GetDataSet(null);//获取全部数据直接用null

//绑定分页控件
SqlPager1.UseCustomDataSource = true;
SqlPager1.CustomDataSource = testds;
SqlPager1.DataBind();

//使用AJAX分页，返回数据并显示
private void PageChange1()
{
	int newPageIndex = Convert.ToInt32(Request["newIndex"]);
	SqlPager4.GoToPage(newPageIndex);
	StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
	HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

	if (GridView2 != null)
	{
		GridView2.Visible = true;
		GridView2.RenderControl(writer2);
	}
	SqlPager4.RenderControl(writer2);
	writer2.Flush();
	writer2.Close();
	Response.Write(writer1.ToString());
	Response.End();
}
</code></pre>

 </div> 
 
</div>


  </form>
  
<div class="top"><br /><a href=# title="返回顶部">Top</a>
</div>	
</asp:Content>

