﻿using System;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using Winson.Framework.DBProviders;
using Winson.Framework.LogProviders;
using Winson.EntityOP.Base;
using Winson.EntityOP.Entity;

namespace Winson.EntityOP.BaseEntityOP
{	
	/// <summary>
    /// Test实体操作类
    /// </summary>
	public class TestOP : BaseOP
    {
        #region 私有变量
        List<TestDS> TestList;
        TestDS testDS;
        ArrayList fieldName;
        ArrayList fieldValue;
        List<ArrayList> fieldNameList;
        List<ArrayList> fieldValueList;
        #endregion

        #region 构造函数
        public TestOP()
        {
            _tableName = "Test";
            sql = "select * from " + _tableName;
            _primekey = GetPrimeKey();
        }
        #endregion              

        #region 查询操作
        /// <summary>
        /// 获取实体集合
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件;如为NULL则获取所有实体</param>
        /// <param name="conditionValue">
		///	条件参数，有以下3种：
		///	1.如为NULL则获取所有实体
		///	2.如键名为"sql"，则为完整的自定义sql语句
		///	3.如键名为"where"，则为自定义条件（已包括where）;			
		///	</param>
        /// <returns>实体集合</returns>
        public List<TestDS> GetList(NameValueCollection conditionValue) 
        {
            try
            {
                TestList = new List<TestDS>();
                //将数据填充到实体集合
                DbDataReader dr = null;
                dr = DBManage.ExecuteReader(DBManage.Conn, sql, conditionValue);
                if (dr != null)
                {
					while (dr.Read())
					{
						testDS = new TestDS();
						FillDS(testDS, dr);
						TestList.Add(testDS);
					}
                }
                return TestList;
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { conditionValue });
                return null;
            }
            finally
            {
                DBManage.Conn.Close();
            }
        }
        /// <summary>
        /// 从数据库中获取单个实体
        /// </summary>       
        /// <param name="conditionValue">
		///	条件参数，有以下3种：
		///	1.如为NULL则获取最后一个新增的实体
		///	2.如键名为"sql"，则为完整的自定义sql语句
		///	3.如键名为"where"，则为自定义条件（已包括where）;			
		///	</param>
        /// <returns>实体</returns>
        public TestDS GetEntity(NameValueCollection conditionValue)
        {
            DbDataReader dr = null;
            try
            {   
				 string tSql = string.Empty;
                if (conditionValue == null)
                {
                    tSql = DBManage.GenerateGetOneEntitySql(_tableName, _primekey);
                    dr = DBManage.ExecuteReader(DBManage.Conn, tSql, conditionValue);
                }
                else
                    dr = DBManage.ExecuteReader(DBManage.Conn, sql, conditionValue);
                
                if (dr != null && dr.Read())
                {
                    testDS = new TestDS();
                    FillDS(testDS, dr);
                    return testDS;
                }
                else
                    return null;
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { conditionValue });
                return null;
            }
            finally
            {
                if(dr!=null)   dr.Close();
                DBManage.Conn.Close();
            }
        }
        /// <summary>
        /// 从实体集合中获取单个实体
        /// </summary>
        /// <param name="entityList">实体集合</param>
        /// <param name="fieldID">实体ID</param>
        /// <returns>实体</returns>
        public TestDS GetEntity(IList entityList, int fieldID)
        {
            try
            {
                foreach (TestDS test_DS in entityList)
                {
                    if (test_DS.Id == fieldID)
                        return test_DS;
                }
                return null;
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { entityList, fieldID });
                return null;
            }
        }
        #endregion

        #region 单实体操作
        /// <summary>
        /// 添加实体
        /// </summary>
        /// <param name="ds">实体</param>
        /// <returns>影响记录数</returns>
        public int Add(TestDS ds)
        {
            try
            {
                fieldName = new ArrayList();
                fieldValue = new ArrayList();
                int maxID = GetMaxID();
                if (maxID == 0) return 0;
                for (int i = 0; i < ds.Count; i++)
                {
                    if (ds[i, 1, maxID] != null)
                    {
                        fieldName.Add(ds[i, 1, maxID]);//51aspx
                        fieldValue.Add(ds[i, 0, maxID]);
                    }
                }
                return DBManage.ExecuteNonQuery(DBAction.Insert, _tableName, fieldName, fieldValue);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { ds });//51aspx
                return 0;
            }
        }
        /// <summary>
        /// 更新实体
        /// </summary>
        /// <param name="ds">实体</param>        
        /// <param name="conditionValue">
		///	条件参数，有以下2种：
		///	1.如键名为"sql"，则为完整的自定义sql语句
		///	2.如键名为"where"，则为自定义条件（已包括where）;			
		///	</param>
        /// <returns>影响记录数</returns>
        public int Update(TestDS ds, NameValueCollection conditionValue)
        {
            try
            {
                fieldName = new ArrayList();
                fieldValue = new ArrayList();
                for (int i = 0; i < ds.Count; i++)
                {
                    if (ds[i, 1, 0] != null)
                    {
                        fieldName.Add(ds[i, 1, 0]);
                        fieldValue.Add(ds[i, 0, 0]);
                    }
                }
                return DBManage.ExecuteNonQuery(DBAction.Update, _tableName, fieldName, fieldValue, conditionValue);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { ds, conditionValue });
                return 0;
            }
        }
        /// <summary>
        /// 删除实体
        /// </summary>        
        /// <param name="conditionValue">
		///	条件参数，有以下2种：
		///	1.如键名为"sql"，则为完整的自定义sql语句
		///	2.如键名为"where"，则为自定义条件（已包括where）;			
		///	</param>
        /// <returns>影响记录数</returns>
        public int Delete(NameValueCollection conditionValue)
        {
            try
            {
                return DBManage.ExecuteNonQuery(DBAction.Delete, _tableName, null, null, conditionValue);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { conditionValue });
                return 0;
            }
        }
        #endregion

        #region 批量操作

        /// <summary>
        /// 批量添加实体
        /// </summary>
        /// <param name="dsList">实体集合</param>
        /// <returns>成功返回True 否则返回False</returns>
        public bool AddBatch(List<TestDS> dsList)
        {
            try
            {                
                fieldNameList = new List<ArrayList>();
                fieldValueList = new List<ArrayList>();
                int maxID = GetMaxID();
                if (maxID == 0) return false;
                
                dsList.ForEach(
					delegate(TestDS ds)               
						{
							fieldName = new ArrayList();
							fieldValue = new ArrayList();
							for (int n = 0; n < ds.Count; n++)
							{
								if (ds[n, 1, maxID] != null)
								{
									fieldName.Add(ds[n, 1, maxID]);
									fieldValue.Add(ds[n, 0, maxID]);
								}
							}
							maxID++;
							fieldNameList.Add(fieldName);
							fieldValueList.Add(fieldValue);
						}
				);
                return DBManage.ExecuteBatch(DBAction.Insert, _tableName, fieldNameList, fieldValueList);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { dsList });
                return false;
            }
        }

        /// <summary>
        /// 批量更新实体
        /// </summary>
        /// <param name="dsList">实体集合</param>
        /// <returns>成功返回True 否则返回False</returns>
        public bool UpdateBatch(List<TestDS> dsList)
        {
            try
            {
                fieldNameList = new List<ArrayList>();
                fieldValueList = new List<ArrayList>();

                dsList.ForEach(
					delegate(TestDS ds) 
					{
						if (ds[0, 1, 0] != null)
						{
							fieldName = new ArrayList();
							fieldValue = new ArrayList();
							for (int n = 0; n < ds.Count; n++)
							{
								if (ds[n, 1, 0] != null)
								{
									fieldName.Add(ds[n, 1, 0]);
									fieldValue.Add(ds[n, 0, 0]);
								}
							}
							fieldNameList.Add(fieldName);
							fieldValueList.Add(fieldValue);
						}
						else
							throw new Exception("主键值未设置，不能进行批量更新操作！主键必须为第一个字段");
					}
                );
                return DBManage.ExecuteBatch(DBAction.Update, _tableName, fieldNameList, fieldValueList);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { dsList });
                return false;
            }
        }

        /// <summary>
        /// 批量删除实体
        /// </summary>
        /// <param name="dsList">实体集合</param>
        /// <returns>成功返回True 否则返回False</returns>
        public bool DeleteBatch(List<TestDS> dsList)
        {
            try
            {
                fieldNameList = new List<ArrayList>();
                fieldValueList = new List<ArrayList>();

                dsList.ForEach(
					delegate(TestDS ds) 
					{
						if (ds[0, 1, 0] != null)
						{
							fieldName = new ArrayList();
							fieldValue = new ArrayList();
							for (int n = 0; n < ds.Count; n++)
							{
								if (ds[n, 1, 0] != null)
								{
									fieldName.Add(ds[n, 1, 0]);
									fieldValue.Add(ds[n, 0, 0]);
								}
							}
							fieldNameList.Add(fieldName);
							fieldValueList.Add(fieldValue);
						}
						else
							throw new Exception("主键值未设置，不能进行批量删除操作！主键必须为第一个字段");
					}                
				);				
				return DBManage.ExecuteBatch(DBAction.Delete, _tableName, fieldNameList, fieldValueList);
            }				
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { dsList });
                return false;
            }
        }
        #endregion
    }
}


