﻿using System;

namespace Winson.EntityOP.Entity
{	
	/// <summary>
    /// Employees表实体类
    /// </summary>
	public class EmployeesDS
    {
        public EmployeesDS(){}
        
		#region 成员
		private int _id;
		private string _lastname;	
		private string _firstname;	
		private string _title;	
		private System.DateTime _birthdate;	
		private string _address;	
		private string _city;	
		private string _country;	
		private string _homephone;	
		private bool _isphoto;
		private bool _isphotoSetValue = false;
		private string _notes;	
		private string _photopath;	
		private System.Byte[] _pic;	
							
				
			
		/// <summary>
		/// 获取或设置Id(可读写)
		/// </summary>
		public int Id
		{ 
			get {return _id;} 
			set { _id = value; }
		}
			
		/// <summary>
		/// 获取或设置Lastname(可读写)
		/// </summary>
		public string Lastname
		{ 
			get {return _lastname;} 
			set { _lastname = value; }
		}
			
		/// <summary>
		/// 获取或设置Firstname(可读写)
		/// </summary>
		public string Firstname
		{ 
			get {return _firstname;} 
			set { _firstname = value; }
		}
			
		/// <summary>
		/// 获取或设置Title(可读写)
		/// </summary>
		public string Title
		{ 
			get {return _title;} 
			set { _title = value; }
		}
			
		/// <summary>
		/// 获取或设置Birthdate(可读写)
		/// </summary>
		public System.DateTime Birthdate
		{ 
			get {return _birthdate;} 
			set { _birthdate = value; }
		}
			
		/// <summary>
		/// 获取或设置Address(可读写)
		/// </summary>
		public string Address
		{ 
			get {return _address;} 
			set { _address = value; }
		}
			
		/// <summary>
		/// 获取或设置City(可读写)
		/// </summary>
		public string City
		{ 
			get {return _city;} 
			set { _city = value; }
		}
			
		/// <summary>
		/// 获取或设置Country(可读写)
		/// </summary>
		public string Country
		{ 
			get {return _country;} 
			set { _country = value; }
		}
			
		/// <summary>
		/// 获取或设置Homephone(可读写)
		/// </summary>
		public string Homephone
		{ 
			get {return _homephone;} 
			set { _homephone = value; }
		}
			
		/// <summary>
		/// 获取或设置Isphoto(可读写)
		/// </summary>
		public bool Isphoto
		{ 
			get {return _isphoto;} 
			set { _isphoto = value; _isphotoSetValue = true;}
		}
			
		/// <summary>
		/// 获取或设置Notes(可读写)
		/// </summary>
		public string Notes
		{ 
			get {return _notes;} 
			set { _notes = value; }
		}
			
		/// <summary>
		/// 获取或设置Photopath(可读写)
		/// </summary>
		public string Photopath
		{ 
			get {return _photopath;} 
			set { _photopath = value; }
		}
			
		/// <summary>
		/// 获取或设置Pic(可读写)
		/// </summary>
		public System.Byte[] Pic
		{ 
			get {return _pic;} 
			set { _pic = value; }
		}
		/// <summary>
		/// 获取字段数量(只读)
		/// </summary>
        public int Count{get { return 13; }}
        #endregion

		#region 索引器
        public object this[int index, int type, int maxID]
        {			 
			get
			{
				if(type==1)
                {
                    #region 返回字段名
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0 || Id > 0)
								 return "Id";
							 else
								 return null;
						 case 1:
							 if(Lastname != null && Lastname.Length > 0)
								 return "Lastname";
							 else
								 return null;
						 case 2:
                             if (Firstname != null && Firstname.Length > 0)//5-1-a-s-p-x
								 return "Firstname";
							 else
								 return null;
						 case 3:
							 if(Title != null && Title.Length > 0)
								 return "Title";
							 else
								 return null;
						 case 4:
							 if(Birthdate != DateTime.MaxValue && Birthdate != DateTime.MinValue)
								 return "Birthdate";
							 else
								 return null;
						 case 5:
							 if(Address != null && Address.Length > 0)
								 return "Address";
							 else
								 return null;
						 case 6:
							 if(City != null && City.Length > 0)
								 return "City";
							 else
								 return null;
						 case 7:
							 if(Country != null && Country.Length > 0)
								 return "Country";
							 else
								 return null;
						 case 8:
							 if(Homephone != null && Homephone.Length > 0)
								 return "Homephone";
							 else
								 return null;
						 case 9:
							 if(_isphotoSetValue)
								 return "Isphoto";
							 else
								 return null;
						 case 10:
							 if(Notes != null && Notes.Length > 0)
								 return "Notes";
							 else
								 return null;
						 case 11:
							 if(Photopath != null && Photopath.Length > 0)
								 return "Photopath";
							 else
								 return null;
						 case 12:
							 if(Pic != null)
								 return "Pic";
							 else
								 return null;
                        default:
                            return null;                           
                    }
                    #endregion
                }
                else
                {
                    #region 返回字段值
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0)
								 return maxID;
							 else if(Id > 0)
								 return  Id;
							 else
								 return null;
						 case 1:
								 return Lastname;
						 case 2:
								 return Firstname;
						 case 3:
								 return Title;
						 case 4:
								 return Birthdate;
						 case 5:
								 return Address;
						 case 6:
								 return City;
						 case 7:
								 return Country;
						 case 8:
								 return Homephone;
						 case 9:
								 return Isphoto;
						 case 10:
								 return Notes;
						 case 11:
								 return Photopath;
						 case 12:
								 return Pic;
                        default:
                            return null;
                    }
                    #endregion//5~1-a-s-p-x
                }
			}	            
        }
		#endregion
	}
}


