﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace Winson.ModelOP
{
    /// <summary>
    /// 实体集合类
    /// </summary>
    public class ModelCollection<T> : CollectionBase
    {
        #region 实体集合相关操作
        /// <summary>
        /// 实体集合索引器
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public T this[int index]
        {
            get { return (T)List[index]; }
            set { List[index] = value; }
        }
        /// <summary>
        /// 为集合添加一个实体
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public int Add(T value)
        {
            return (List.Add(value));
        }
        /// <summary>
        /// 查找特定项的索引
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public int IndexOf(T value)
        {
            return (List.IndexOf(value));
        }
        /// <summary>
        /// 将一个项插入指定索引处
        /// </summary>
        /// <param name="index">索引</param>
        /// <param name="value">要插入的项</param>
        public void Insert(int index, T value)
        {
            List.Insert(index, value);
        }
        /// <summary>
        /// 移除一个实体
        /// </summary>
        /// <param name="value"></param>
        public void Remove(T value)
        {
            List.Remove(value);
        }
        /// <summary>
        /// 是否包含特定的值 
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public bool Contains(T value)
        {
            return (List.Contains(value));
        }
        #endregion
    }
}
