using System;
using System.Web.UI;
using System.Web.UI.Design;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Design;

namespace Winson.Framework.Controls
{
    /// <summary>
    /// ڹӿؼ
    /// </summary>
    [DefaultProperty("PopupToShow"), ToolboxData("<{0}:PopupWinAnchor runat=server></{0}:PopupWinAnchor>")]
    [Designer(typeof(AnchorDesigner))]
    public class PopupWinAnchor : System.Web.UI.WebControls.WebControl
    {
        #region 

        string controlId, controlLink, jsEvent;
        string snMsg, snText, snTitle;
        bool bChangeText = false;
        bool _popupToShowIsMP = false;
        bool _linkedControlIsMP = false;

        #endregion

        #region 캯

        /// <summary>
        /// ؼ
        /// </summary>
        public PopupWinAnchor()
        {
            jsEvent = "onclick";
            bChangeText = false;
        }

        #endregion

        #region 

        /// <summary>
        /// Ƿѵı滻Ϊµı
        /// </summary>
        [Bindable(true), Category("PopupWin"), DefaultValue(false)]
        [Description("Ƿѵı滻Ϊµı")]
        public bool ChangeTexts
        {
            get { return bChangeText; }
            set { bChangeText = value; }
        }


        /// <summary>
        /// µϢı
        /// </summary>
        [Bindable(true), Category("PopupWin"), DefaultValue("")]
        [Description("µϢı")]
        public string NewMessage
        {
            get { return snMsg; }
            set { snMsg = value; }
        }


        /// <summary>
        /// µĵڱ
        /// </summary>
        [Bindable(true), Category("PopupWin"), DefaultValue("")]
        [Description("µĵڱ")]
        public string NewTitle
        {
            get { return snTitle; }
            set { snTitle = value; }
        }

        /// <summary>
        /// ´ʾı
        /// </summary>
        [Bindable(true), Category("PopupWin"), DefaultValue("")]
        [Description("´ʾı")]
        public string NewText
        {
            get { return snText; }
            set { snText = value; }
        }


        /// <summary>
        /// JavaScript¼
        /// </summary>
        [Bindable(true), Category("Anchor"), DefaultValue("onclick")]
        [Editor(typeof(JavaScriptEventEditor), typeof(UITypeEditor))]
        [Description("JavaScript¼")]
        public string HandledEvent
        {
            get { return jsEvent; }
            set { jsEvent = value; }
        }


        /// <summary>
        /// ¼ʱʾڿؼ
        /// </summary>
        [Bindable(true), Category("Anchor"), DefaultValue("")]
        [Editor(typeof(PopupControlsEditor), typeof(UITypeEditor))]
        [Description("¼ʱʾڿؼ")]
        public string PopupToShow
        {
            get { return controlId;}
            set { controlId = value; }
        }

        /// <summary>
        /// ʾ¼ԪأԪID
        /// </summary>
        [Bindable(true), Category("Anchor"), DefaultValue("")]
        [Editor(typeof(AllControlsEditor), typeof(UITypeEditor))]
        [Description("ʾ¼ԪأԪID")]
        public string LinkedControl
        {
            get{ return controlLink;}
            set
            {
                if (_linkedControlIsMP && ContentPlaceHolderID.Length > 0)
                    controlLink = "ctl00_" + ContentPlaceHolderID + "_" + controlLink; 
                controlLink = value;
            }
        }

        // <summary>
        /// ûȡĸҳǰҳID
        /// </summary>
        [Description("ûȡĸҳǰҳID")]
        public string ContentPlaceHolderID
        {
            get { return Convert.ToString(ViewState["ContentPlaceHolderID"]); }
            set { ViewState["ContentPlaceHolderID"] = value; }
        }

        // <summary>
        /// PopupToShowԪǷҪʹĸҳ
        /// </summary>
        [Bindable(true), Category("Anchor"), DefaultValue(false)]
        [Description("PopupToShowԪǷҪʹĸҳ")]
        public bool PopupToShowIsMP
        {
            get { return _popupToShowIsMP; }
            set { _popupToShowIsMP = value; }
        }

        // <summary>
        /// LinkedControlԪǷҪʹĸҳ
        /// </summary>
        [Bindable(true), Category("Anchor"), DefaultValue(false)]
        [Description("LinkedControlԪǷҪʹĸҳ")]
        public bool LinkedControlIsMP
        {
            get { return _linkedControlIsMP; }
            set { _linkedControlIsMP = value; }
        }

        #endregion

        #region 

        /// <summary> 
        /// ʾڿؼʱֽű
        /// </summary>
        /// <param name="output">HtmlTextWriter</param>
        protected override void Render(HtmlTextWriter output)
        {
            string _controlId = controlId;

            if (_popupToShowIsMP && ContentPlaceHolderID.Length > 0)
                controlId = "ctl00_" + ContentPlaceHolderID + "_" + controlId; 

            if (_linkedControlIsMP && ContentPlaceHolderID.Length > 0)
                controlLink = "ctl00_" + ContentPlaceHolderID + "_" + controlLink; 

            output.Write(@"
        <script type=""text/javascript"">
        //<![CDATA[

        var " + ID + @"oldOnLoad=window.onload;
        window.onload=" + ID + @"espopup_anchorInit;
        function " + ID + @"espopup_anchorInit()
        {
          if (" + ID + @"oldOnLoad!=null) " + ID + @"oldOnLoad();
          document.getElementById('" + controlLink + @"')." + jsEvent + @"=" +
              ID + @"espopup_anchorEvent;
        }

        function " + ID + @"espopup_anchorEvent()
        {
          ");
            if (bChangeText)
            {
                Control ct = Page.FindControl(controlId);
                //ĸҳĴ
                if (ct == null && ContentPlaceHolderID != "")
                {
                    ct = ((ContentPlaceHolder)Page.Master.FindControl(ContentPlaceHolderID)).FindControl(_controlId);
                }

                if (ct != null)
                {
                    output.Write(controlId + "nText=\"" +
                      ((PopupWin)ct).GetWinText(snTitle, snText) + "\";\n");
                }
                output.Write(controlId + "nMsg=\"" + snMsg + "\";\n");
                output.Write(controlId + "nTitle=\"" + snTitle + "\";\n");
                output.Write(controlId + "bChangeTexts=true;\n");
            }
            else
            {
                output.Write(controlId + "bChangeTexts=false;\n");
            }
            output.Write("\n" + controlId + @"espopup_ShowPopup('" + ID + @"');
        }
        //]]>
        </script>");
        }

        #endregion
    }


    /// <summary>
    /// ʾڿؼ
    /// </summary>
    public class AnchorDesigner : ControlDesigner
    {
        #region Overriden methods

        /// <summary>
        /// HTML
        /// </summary>
        public override string GetDesignTimeHtml()
        {
            return "<div style=\"padding:2px; background-color: ButtonFace;color:ButtonText; " +
              "border-style:outset; border-width:1px; font: 75% 'Microsoft Sans Serif';\"><b>" +
              "PopupWinAnchor</b> - " + ((Control)Component).ID + "</div>";
        }

        #endregion
    }


    /// <summary>
    /// ༭ѡJavaScript¼
    /// </summary>
    public class JavaScriptEventEditor : UITypeEditor
    {
        #region 

        private System.Windows.Forms.Design.IWindowsFormsEditorService edSvc = null;
        private System.Windows.Forms.ListBox lb;

        #endregion

        #region 

        /// <summary>
        /// дѡ༭Ϊ
        /// Զؼʾ༭ֵ
        /// Overrides the method used to provide basic behaviour for selecting editor.
        /// Shows our custom control for editing the value.
        /// </summary>
        /// <param name="context">༭ؼ</param>
        /// <param name="provider">һЧķṩ</param>
        /// <param name="value">ǰҪ༭Ķֵ</param>
        /// <returns>ֵ</returns>
        public override object EditValue(ITypeDescriptorContext context,
          IServiceProvider provider, object value)
        {
            if (context != null && context.Instance != null && provider != null)
            {
                edSvc = (System.Windows.Forms.Design.IWindowsFormsEditorService)
                  provider.GetService(typeof(System.Windows.Forms.Design.IWindowsFormsEditorService));
                if (edSvc != null)
                {
                    lb = new System.Windows.Forms.ListBox();
                    lb.BorderStyle = System.Windows.Forms.BorderStyle.None;
                    lb.SelectedIndexChanged += new EventHandler(lb_SelectedIndexChanged);
                    lb.Items.Add("onclick");
                    lb.Items.Add("ondblclick");
                    lb.Items.Add("onmouseover");
                    lb.Items.Add("onfocus");
                    lb.Items.Add("oncontextmenu");
                    edSvc.DropDownControl(lb);
                    if (lb.SelectedIndex == -1) return value;
                    return lb.SelectedItem;
                }
            }

            return value;
        }


        /// <summary>
        /// ѡ༭
        /// </summary>
        /// <param name="context">༭</param>
        /// <returns> <c>UITypeEditorEditStyle.DropDown</c></returns>
        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
        {
            return UITypeEditorEditStyle.DropDown;
        }


        /// <summary>
        /// ûѡһֵ󣬹رմؼ
        /// </summary>
        private void lb_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (edSvc != null)
            {
                edSvc.CloseDropDown();
            }
        }

        #endregion
    }


    /// <summary>
    /// ASP.NETҳѡĿؼı༭
    /// Editor for selecting controls from Asp.Net page
    /// </summary>
    public abstract class ControlsEditor : UITypeEditor
    {
        #region 

        private System.Windows.Forms.Design.IWindowsFormsEditorService edSvc = null;
        private System.Windows.Forms.ListBox lb;
        private Type typeShow;

        #endregion

        #region 캯


        /// <summary>
        /// ʾָ
        /// </summary>
        /// <param name="show"></param>
        public ControlsEditor(Type show)
        {
            typeShow = show;
        }

        #endregion

        #region 

        /// <summary>
        /// дѡ༭Ϊ
        /// Զؼʾ༭ֵ
        /// Overrides the method used to provide basic behaviour for selecting editor.
        /// Shows our custom control for editing the value.
        /// </summary>
        /// <param name="context">༭ؼ</param>
        /// <param name="provider">һЧķṩ</param>
        /// <param name="value">ǰҪ༭Ķֵ</param>
        /// <returns>ֵ</returns>
        public override object EditValue(ITypeDescriptorContext context,
          IServiceProvider provider, object value)
        {
            if (context != null && context.Instance != null && provider != null)
            {
                edSvc = (System.Windows.Forms.Design.IWindowsFormsEditorService)
                  provider.GetService(typeof(System.Windows.Forms.Design.IWindowsFormsEditorService));
                if (edSvc != null)
                {
                    lb = new System.Windows.Forms.ListBox();
                    lb.BorderStyle = System.Windows.Forms.BorderStyle.None;
                    lb.SelectedIndexChanged += new EventHandler(lb_SelectedIndexChanged);
                    foreach (Control ctrl in ((Control)context.Instance).Page.Controls)
                    {
                        if (ctrl.GetType().IsSubclassOf(typeShow) ||
                          ctrl.GetType().FullName == typeShow.FullName) lb.Items.Add(ctrl.ID);
                    }
                    edSvc.DropDownControl(lb);
                    if (lb.SelectedIndex == -1) return value;
                    return lb.SelectedItem;
                }
            }

            return value;
        }


        ///// <summary>
        /// ѡ༭
        /// </summary>
        /// <param name="context">༭</param>
        /// <returns> <c>UITypeEditorEditStyle.DropDown</c></returns>
        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
        {
            return UITypeEditorEditStyle.DropDown;
        }


        /// <summary>
        /// ûѡһֵ󣬹رմؼ
        /// </summary>
        private void lb_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (edSvc != null)
            {
                edSvc.CloseDropDown();
            }
        }

        #endregion
    }


    /// <summary>
    /// ASP.NETı༭
    /// </summary>
    public class AllControlsEditor : ControlsEditor
    {
        #region Members

        /// <summary>
        /// ûĹ캯
        /// </summary>
        public AllControlsEditor() : base(typeof(Control)) { }

        #endregion
    }


    /// <summary>
    /// ڿؼı༭
    /// </summary>
    public class PopupControlsEditor : ControlsEditor
    {
        #region Members

        /// <summary>
        /// ûĹ캯
        /// </summary>
        public PopupControlsEditor() : base(typeof(PopupWin)) { }

        #endregion
    }
}
