﻿using System;
using System.Collections.Generic;
using System.Text;
using Winson.Framework.Utility;

namespace Winson.Framework.Controls
{
    /// <summary>
    /// 对话框类型
    /// </summary>
    public enum DialogType
    {
        Alert,
        Confirm
    }

    #region 使用jQuery的插件产生对话框
    public class Dialog
    {
        #region  成员属性
        private string _title;
        private string _css;
        private string _opacity;
        private string _okButton;
        private string _cancelButton;
        private string _width;
        private string _height;
        private string _minWidth;
        private string _minHeight;
        private bool _modal;
        private bool _resizable;
        private string _okEvent;
        private string _cancelEvent;
        private DialogType _showType;

        private string _confirmOK;
        private string _confirmCancel;
        private string _confirmOKEvent;
        private string _confirmCancelEvent;

        private System.Web.UI.Page _page;

        #region 为元素添加确认对话框时的相关属性
        /// <summary>
        /// '为元素添加确认对话框'时的确定按钮文本
        /// </summary>
        public string ConfirmOK
        {
            get { return _confirmOK; }
            set { _confirmOK = value; }
        }
        /// <summary>
        /// '为元素添加确认对话框'时的取消按钮文本
        /// </summary>
        public string ConfirmCancel
        {
            get { return _confirmCancel; }
            set { _confirmCancel = value; }
        }
        /// <summary>
        /// '为元素添加确认对话框'时的确定按钮事件,JS语法实现,默认为关闭对话框
        /// </summary>
        public string ConfirmOKEvent
        {
            get { return _confirmOKEvent; }
            set { _confirmOKEvent = value; }
        }
        /// <summary>
        /// '为元素添加确认对话框'时的取消按钮事件,JS语法实现,默认为关闭对话框
        /// </summary>
        public string ConfirmCancelEvent
        {
            get { return _confirmCancelEvent; }
            set { _confirmCancelEvent = value; }
        }
        #endregion

        #region 显示对话框时的相关属性
        /// <summary>
        /// 对话框标题
        /// </summary>
        public string Title
        {
            get { return _title; }
            set { _title = value; }
        }
        /// <summary>
        /// 对话框类型
        /// </summary>
        public DialogType ShowType
        {
            get { return _showType; }
            set { _showType = value; }
        }
        /// <summary>
        /// CSS名称,默认为flora
        /// </summary>
        public string Css
        {
            get { return _css; }
            set { _css = value; }
        }
        /// <summary>
        /// 背景透明度,默认为0.5
        /// </summary>
        public string Opacity
        {
            get { return _opacity; }
            set { _opacity = value; }
        }
        /// <summary>
        /// 确定按钮文本,默认为'OK'
        /// </summary>
        public string OkButton
        {
            get { return _okButton; }
            set { _okButton = value; }
        }
        /// <summary>
        /// 取消按钮文本,默认为'Cancel'
        /// </summary>
        public string CancelButton
        {
            get { return _cancelButton; }
            set { _cancelButton = value; }
        }
        /// <summary>
        /// 对话框宽度,默认为300
        /// </summary>
        public string Width
        {
            get { return _width; }
            set { _width = value; }
        }
        /// <summary>
        /// 对话框高度,默认为200
        /// </summary>
        public string Height
        {
            get { return _height; }
            set { _height = value; }
        }
        /// <summary>
        /// 对话框最小收缩宽度,默认为250
        /// </summary>
        public string MinWidth
        {
            get { return _minWidth; }
            set { _minWidth = value; }
        }
        /// <summary>
        /// 对话框最小收缩高度,默认为150
        /// </summary>
        public string MinHeight
        {
            get { return _minHeight; }
            set { _minHeight = value; }
        }
        /// <summary>
        /// 是否使用模式对话框,默认为true
        /// </summary>
        public bool Modal
        {
            get { return _modal; }
            set { _modal = value; }
        }
        /// <summary>
        /// 是否允许扡动对话框,默认为true
        /// </summary>
        public bool Resizable
        {
            get { return _resizable; }
            set { _resizable = value; }
        }
        /// <summary>
        /// 确定按钮事件,以JS语法实现,默认关闭对话框
        /// </summary>
        public string OkEvent
        {
            get { return _okEvent; }
            set { _okEvent = value; }
        }
        /// <summary>
        /// 取消按钮事件,以JS语法实现,默认关闭对话框
        /// </summary>
        public string CancelEvent
        {
            get { return _cancelEvent; }
            set { _cancelEvent = value; }
        }
        #endregion

        #endregion

        #region 构造函数
        /// <summary>
        /// 初始化属性
        /// </summary>
        public Dialog(System.Web.UI.Page page)
        {
            _title = "Message";
            _css = "flora";
            _opacity = "0.5";
            _okButton = "OK";
            _cancelButton = "Cancel";
            _width = "300";
            _height = "200";
            _minWidth = "280";
            _minHeight = "180";
            _modal = true;
            _resizable = true;
            _page = page;
            _okEvent = "$(this).dialog('close');";
            _cancelEvent = "$(this).dialog('close');";
            _showType = DialogType.Alert;

            _confirmOK = "YES";
            _confirmCancel = "NO";
            _confirmOKEvent = "$(this).dialog('close');";
            _confirmCancelEvent = "$(this).dialog('close');";
        }
        #endregion

        #region 成员函数

        /// <summary>
        /// 显示对话框
        /// </summary>
        /// <param name="msg">显示的信息</param>
        public void ShowMsgBox(string msg)
        {
            StringBuilder script = new StringBuilder();
            script.Append("$(document).ready(function(){");
            script.Append("$('body').append('<div id=\"MsgBox\"></div>');");
            script.Append("$('#MsgBox').html('<div class=\"icon\"></div>" + msg + "').css('display','block').dialog({");
            script.Append("title:'" + _title + " ', modal: " + _modal.ToString().ToLower() + ",");
            script.Append("overlay: { opacity: " + _opacity + ", background: 'black' },");
            script.Append("buttons: { '" + _okButton + "': function() { " + _okEvent + " } ");
            if (_showType == DialogType.Confirm)
                script.Append(" , '" + _cancelButton + "': function() { " + _cancelEvent + " } ");
            script.Append("},");
            script.Append("width:" + _width + ",height:" + _height + ",resizable:" + _resizable.ToString().ToLower() + ",");
            script.Append("close:function(event,ui){$(this).dialog('destroy');},");
            script.Append("minHeight:" + _minHeight + ",minWidth:" + _minWidth + ",dialogClass:'" + _css + "'});});");
            MessageBox.ResponseScript("ShowMsgBox", _page, script.ToString());
        }

        /// <summary>
        /// 为页面元素添加确认对话框
        /// </summary>
        /// <param name="msg">要显示的信息</param>
        /// <param name="element">要附加到的元素</param>
        /// <param name="name">要附加到的元素的name</param>
        public void AddConfirmBox(string msg, string element, string name)
        {
            StringBuilder script = new StringBuilder();
            script.Append("$(document).ready(function(){");
            script.Append("$('" + element + "[name*=\"" + name + "\"]').click(function(){");
            script.Append("$('body').append('<div id=\"MsgBox\"></div>');");
            script.Append("$('#MsgBox').html('<div class=\"icon\"></div>" + msg + "').css('display','block').dialog({");
            script.Append("title:'" + _title + " ', modal: " + _modal.ToString().ToLower() + ",");
            script.Append("overlay: { opacity: " + _opacity + ", background: 'black' },");
            script.Append("buttons: { '" + _confirmOK + "': function() { " + _confirmOKEvent + " } ,");
            script.Append("'" + _confirmCancel + "': function() { " + _confirmCancelEvent + " } ");
            script.Append("},");
            script.Append("width:" + _width + ",height:" + _height + ",resizable:" + _resizable.ToString().ToLower() + ",");
            script.Append("close:function(event,ui){$(this).dialog('destroy');},");
            script.Append("minHeight:" + _minHeight + ",minWidth:" + _minWidth + ",dialogClass:'" + _css + "'});");
            script.Append("});});");
            MessageBox.ResponseScript("AddConfirmBox", _page, script.ToString());
        }

        /// <summary>
        /// 为页面元素添加确认对话框,同时可指定跳转的URL以及传递参数.
        /// 此方法已支持URL重写的跳转页面,只需在web.config里设置相关的UrlRewrite参数即可
        /// </summary>
        /// <param name="msg">要显示的信息</param>
        /// <param name="element">要附加到的元素</param>
        /// <param name="name">要附加到的元素的name</param>
        /// <param name="fileName">要跳转的文件名,不包后缀</param>
        /// <param name="attrID">当作参数用的元素里的属性名</param>
        public void AddConfirmBox(string msg, string element, string name, string fileName, string attrID)
        {
            string actionUrl = string.Empty;
            string fileExt = Utility.Utility.ReadWebConfig("WF.FileExtension", ".aspx");
            string isreurl = Utility.Utility.ReadWebConfig("WF.IsRewriter", "0");

            if (isreurl.Equals("1"))
                actionUrl = "location.href='" + fileName + "-" + attrID + "-'+ $temp.attr('" + attrID + "') +'" + fileExt + "'";
            else
                actionUrl = "location.href='" + fileName + ".aspx?" + attrID + "='+ $temp.attr('" + attrID + "')";

            _confirmOKEvent = actionUrl;

            StringBuilder script = new StringBuilder();
            script.Append("$(document).ready(function(){");
            script.Append("$('" + element + "[name*=\"" + name + "\"]').click(function(){");
            script.Append("$temp=$(this);");
            script.Append("$('body').append('<div id=\"MsgBox\"></div>');");
            script.Append("$('#MsgBox').html('<div class=\"icon\"></div>" + msg + "').css('display','block').dialog({");
            script.Append("title:'" + _title + " ', modal: " + _modal.ToString().ToLower() + ",");
            script.Append("overlay: { opacity: " + _opacity + ", background: 'black' },");
            script.Append("buttons: { '" + _confirmOK + "': function() { " + _confirmOKEvent + " } ,");
            script.Append("'" + _confirmCancel + "': function() { " + _confirmCancelEvent + " } ");
            script.Append("},");
            script.Append("width:" + _width + ",height:" + _height + ",resizable:" + _resizable.ToString().ToLower() + ",");
            script.Append("close:function(event,ui){$(this).dialog('destroy');},");
            script.Append("minHeight:" + _minHeight + ",minWidth:" + _minWidth + ",dialogClass:'" + _css + "'});");
            script.Append("});});");//5!1!a!s!p!x
            MessageBox.ResponseScript("BatchAddConfirmBox", _page, script.ToString());
        }
        #endregion
    }
    #endregion

}
