﻿using System.Configuration;

namespace Winson.Framework.DBProviders
{
    partial class DataBaseProviderConfigurationSection : ConfigurationSection
    {   
        /// <summary>
        /// DataBase的默认的Provider
        /// </summary>
        [StringValidator(MinLength = 1)]
        [ConfigurationProperty("defaultProvider", DefaultValue = "DateBaseProvider")]
        public string DefaultProvider
        {
            get { return (string)base["defaultProvider"]; }
            set { base["defaultProvider"] = value; }
        }       

        /// <summary>
        /// DataBase的所有的Provider集合
        /// </summary>
        [ConfigurationProperty("providers")]
        public ProviderSettingsCollection Providers
        {
            get { return (ProviderSettingsCollection)base["providers"]; }
        }

    }
}
