﻿using System;
using System.ComponentModel;
using System.Data;
using System.Xml;

namespace Winson.Framework.Data.XmlClient
{
    public class XmlCommand : Component, IDbCommand, ICloneable
    {
        private string _commandText = "";
        private XmlConnection _connection = null;
        private int _commandTimeout;
        private string _cmdText;
        private CommandType _cmdType;

        // Constructors
        public XmlCommand()
        {
            _cmdType = CommandType.Text;
            _cmdText = String.Empty;
            _commandTimeout = 30;
        }

        public XmlCommand(string cmdText)
            :this()
        {
            _commandText = cmdText;
        }

        public XmlCommand(string cmdText, XmlConnection conn)
            : this(cmdText)
        {
            _commandText = cmdText;
            _connection = conn;
        }

        [Category("Data")]
		[Description("Command text to execute")]		
        public string CommandText
        {
            get { return _commandText; }
            set { _commandText = value; }
        }

        [Category("Misc")]
        [Description("Time to wait for command to execute")]
        [DefaultValue(30)]
        public int CommandTimeout
        {
            get { return _commandTimeout; }
            set { _commandTimeout = value; }
        }

        [Category("Data")]
        public CommandType CommandType
        {
            get { return _cmdType; }
            set { _cmdType = value; }
        }

        [Category("Behavior")]
        [Description("Connection used by the command")]
        public XmlConnection Connection
        {
            get { return _connection; }
            set
            {
                if (_connection != value)
                    Transaction = null;

                _connection = (XmlConnection)value;
            }
        }

        public IDataParameterCollection Parameters
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        public IDbTransaction Transaction
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
            set { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        public UpdateRowSource UpdatedRowSource
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
            set { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        // Public Methods
        public void Cancel()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public IDbDataParameter CreateParameter()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public int ExecuteNonQuery()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public IDataReader ExecuteReader()
        {
            return null;
        }

        public IDataReader ExecuteReader(CommandBehavior behavior)
        {
            return null;
        }

        public object ExecuteScalar()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public void Prepare()
        {
            //throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        ////////////////////
        // ICloneable
        ////////////////////
        public object Clone()
        {
            return null;
        }

       
    }
}