﻿using System;
using System.ComponentModel;
using System.Data;
using System.Xml;

namespace Winson.Framework.Data.XmlClient
{

    public class XmlConnection : Component, IDbConnection, ICloneable
    {
        private ConnectionState _connState = ConnectionState.Closed;
        private string _connString = "";
        private XmlHelper _doc = new XmlHelper();
        private XmlDataReader dataReader;
        private bool hasBeenOpen;
        private bool isExecutingBuggyQuery;
        private string database;

        // Constructors
        public XmlConnection()
        {
        }

        public XmlConnection(string connectionString)
        {
            _connString = connectionString;
        }

        ////////////////////
        // IDbConnection
        ////////////////////

        // Public Properties
        public string ConnectionString
        {
            get { return _connString; }
            set { _connString = value; }
        }

        public int ConnectionTimeout
        {
            get
            {
                throw new InvalidOperationException("XmlClient Provider does not support this function");
            }
        }
        public string Database
        {
            get
            {
                throw new InvalidOperationException("XmlClient Provider does not support this function");
            }
        }
        public ConnectionState State
        {
            get { return _connState; }
        }

        // Public Methods
        public IDbTransaction BeginTransaction()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public IDbTransaction BeginTransaction(IsolationLevel lvl)
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public void ChangeDatabase(string databaseName)
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public void Close()
        {
            _connState = ConnectionState.Closed;
        }

        public IDbCommand CreateCommand()
        {
            return new XmlCommand("", this);
        }

        public void Open()
        {
            _doc.LoadXML(_connString,XmlHelper.LoadType.FromLocalFile);
            _connState = ConnectionState.Open;
        }

        ////////////////////
        // ICloneable
        ////////////////////
        public object Clone()
        {
            return null;
        }
              

    }
}
