﻿using System;
using System.Data;
using System.Configuration;
using System.Configuration.Provider;
using System.Web.Configuration;
using System.Collections.Specialized;
using System.Collections;
using System.Text;
using System.Reflection;

namespace Winson.Framework.LogProviders
{
    public class LogManage
    {
        private static LogProviderBase _provider;
        private static LogProviderCollection _providers;
        private static object _lock = new object();
        private static bool _useErrLog;
        private static bool _useEventLog;
        private static string _eventTable;

        #region 私有方法

        /// <summary>
        /// 当前Provider
        /// </summary>
        private static LogProviderBase Provider
        {
            get { return _provider; }
        }
        /// <summary>
        /// 所有Provider集合
        /// </summary>
        private static LogProviderCollection Providers
        {
            get { return _providers; }
        }
        /// <summary>
        /// 获取provider
        /// </summary>
        private static void GetProviders()
        {
            //如果 _provider 为空，则创建一个
            if (_provider == null)
            {
                lock (_lock)
                {
                    if (_provider == null)
                    {
                        // 获取 <DBProvider> 配置节
                        LogProviderConfigurationSection section = (LogProviderConfigurationSection)WebConfigurationManager.GetSection("Winson.Framework/LogProvider");

                        _providers = new LogProviderCollection();
                        ProvidersHelper.InstantiateProviders(section.Providers, _providers, typeof(LogProviderBase));
                        _provider = _providers[section.DefaultProvider];

                        _useErrLog = Convert.ToBoolean(section.UseErrLog);
                        _useEventLog = Convert.ToBoolean(section.UseEventLog);
                        _eventTable = section.EventTable;

                        if (_provider == null)
                            throw new ProviderException("不能获取默认的 LogProvider");
                    }
                }
            }
        }

        #endregion

        /// <summary>
        /// 写入异常日志
        /// </summary>
        /// <param name="e">异常</param>
        /// <param name="parames">异常参数</param>
        /// <returns>成功为True 否则为False</returns>
        public static bool OutputErrLog(Exception e, Object[] parames)
        {
            GetProviders();
            if (_useErrLog)
            {
                MethodInfo __method = (MethodInfo)(new System.Diagnostics.StackTrace().GetFrame(1).GetMethod());//从堆栈中获得异常方法

                Hashtable _parameters = new Hashtable();

                //将参数信息放入一个哈希表中
                if (parames != null && __method.GetParameters() != null)
                {
                    foreach (ParameterInfo pi in __method.GetParameters())
                    {
                        if (parames.Length <= pi.Position)
                            _parameters.Add(pi.Name, "");
                        else
                            _parameters.Add(pi.Name, parames[pi.Position]);
                    }
                }

                string parameList = "[";
                if (_parameters != null)
                {
                    foreach (DictionaryEntry de in _parameters)
                    {
                        if (de.Value != null)
                            parameList += de.Key.ToString() + "=" + de.Value.ToString() + ";";
                    }
                }
                parameList += "]";

                return Provider.OutputErrLog(__method.Name, parameList, e);
            }
            else
                return false;
        }

        /// <summary>
        /// 写入事务日志
        /// </summary>
        /// <param name="eventName">事务名称，即当前操作</param>
        /// <param name="user">操作者</param>
        /// <param name="msg">操作信息</param>
        /// <returns>成功为True 否则为False</returns>
        public static bool OutputEventLog(string eventName,string user, string msg)
        {
            GetProviders();
            if (_useEventLog)
            {
                NameValueCollection param = new NameValueCollection();
                //将记录写入数据库对应的字段,可根据数据库结构自行填写
                param["EventName"] = eventName;
                param["[User]"] = user;
                param["Msg"] = msg;
                return Provider.OutputEventLog(_eventTable, param);
            }
            else
                return false;
        }
    }
}
