﻿using System.Configuration;

namespace Winson.Framework.LogProviders
{
    partial class LogProviderConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// LogProvider的默认的Provider
        /// </summary>
        [StringValidator(MinLength = 1)]
        [ConfigurationProperty("defaultProvider", DefaultValue = "Log2XMLProvider")]
        public string DefaultProvider
        {
            get { return (string)base["defaultProvider"]; }
            set { base["defaultProvider"] = value; }
        }

        /// <summary>
        /// EventLog的默认数据存放表名
        /// </summary>
        [StringValidator(MinLength = 1)]
        [ConfigurationProperty("eventTable", DefaultValue = "EventLog")]
        public string EventTable
        {
            get { return (string)base["eventTable"]; }
            set { base["eventTable"] = value; }
        }

        /// <summary>
        /// 是否使用异常日志
        /// </summary>
        [StringValidator(MinLength = 1)]
        [ConfigurationProperty("useErrLog", DefaultValue = "False")]
        public string UseErrLog
        {
            get { return (string)base["useErrLog"]; }
            set { base["useErrLog"] = value; }
        }

        /// <summary>
        /// 是否使用事务日志
        /// </summary>
        [StringValidator(MinLength = 1)]
        [ConfigurationProperty("useEventLog", DefaultValue = "False")]
        public string UseEventLog
        {
            get { return (string)base["useEventLog"]; }
            set { base["useEventLog"] = value; }
        }

        /// <summary>
        /// LogProvider的所有的Provider集合
        /// </summary>
        [ConfigurationProperty("providers")]
        public ProviderSettingsCollection Providers
        {
            get { return (ProviderSettingsCollection)base["providers"]; }
        }
    }
}
