﻿using System;
using System.IO;
using System.Data;
using System.Configuration;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Text.RegularExpressions;
using Microsoft.VisualBasic;

namespace Winson.Framework.Utility
{
    /// <summary>
    /// RegexInfo结构,用来存储从xml文件中读取到的数据 
    /// </summary>
    public struct RegexInfo
    {
        public string _before;
        public string _after;
        public RegexInfo(string before, string after)
        {
            _before = before.ToLower();
            _after = after.ToLower();
        }
    }
    
    /// <summary>
    /// ipFilter结构,用来存储被封的IP 
    /// </summary>
    public struct ipFilter
    {
        public string _ip;
        public ipFilter(string ip)
        {
            _ip = ip;
        }
    }
    
    /// <summary>
    /// 进行URL重写
    /// </summary>
    public class UrlRewriter : IHttpHandler   //实现IHttpHandler接口 
    {
        private List<RegexInfo> _regex_list = new List<RegexInfo>();
        private List<ipFilter> _ip_filter = new List<ipFilter>();
        /// <summary>
        /// 是否使用URL重写
        /// </summary>
        public bool IsRewrite
        {
            get { 
                return Convert.ToBoolean(Utility.ReadWebConfig("WF.IsRewriter","False"));
            }
        }
        /// <summary>
        /// URL重写配置路径 
        /// </summary>
        public string RulesPath
        {
            get {
                return Utility.ReadWebConfig("WF.Rules", "~/AppConfig/Regexs.xml");
            }
        }
        /// <summary>
        /// 禁止IP列表配置文件路径
        /// </summary>
        public string BlockIPPath
        {
            get
            {
                return Utility.ReadWebConfig("WF.BlockIP", "~/AppConfig/IPFilter.xml");
            }
        }
        /// <summary>
        /// 构造函数
        /// </summary>
        public UrlRewriter()
        {
            DataSet ds = new DataSet();
            //读取url重写规则文件,并写入RegexInfo结构的实例中 

            ds.ReadXml(System.Web.HttpContext.Current.Server.MapPath(RulesPath));
            foreach (DataRow r in ds.Tables["regex"].Rows)
                _regex_list.Add(new RegexInfo(((string)r["b"]).Trim(), ((string)r["a"]).Trim()));
            ds.Reset();
            //读取被封的IP列表 
            ds.ReadXml(System.Web.HttpContext.Current.Server.MapPath(BlockIPPath));
            foreach (DataRow r in ds.Tables["IpFilters"].Rows)
                _ip_filter.Add(new ipFilter((string)r["ip"]));
        }
        /// <summary>
        /// 替换重写URL
        /// </summary>
        /// <param name="context">HttpContext对象</param>
        public void ProcessRequest(HttpContext context)
        {
            if (IsRewrite)
            {
                string _ip = context.Request.UserHostAddress;   //获取IP 
                foreach (ipFilter r in _ip_filter)
                {
                    if (_ip == r._ip)
                    {
                        context.Response.Write("对不起,您的IP:" + _ip + "已被限制!");
                        context.Response.End();
                    }
                }
                string path = context.Request.Path.ToLower();   //获取当前访问的重写过的虚假URL 
                foreach (RegexInfo r in _regex_list)
                    path = Regex.Replace(path, r._before, r._after);      //匹配出其真实的URL 
                context.Server.Execute(path);
            }
        }

        // 重写 IsReusable 属性. 
        public bool IsReusable
        {
            get { return true; }
        }
    }
}
