﻿using System;
using System.ComponentModel;
using System.Data;
using System.Xml;

namespace System.Data.XmlClient
{

    public class XmlCommand : Component, IDbCommand, ICloneable
    {
        // Constructors
        public XmlCommand()
        {
        }

        public XmlCommand(string sCommand)
        {
            _commandText = sCommand;
            _connection = null;
        }

        public XmlCommand(string sCommand, XmlConnection conn)
        {
            _commandText = sCommand;
            _connection = conn;
        }

        ////////////////////
        // IDbCommand
        ////////////////////

        // Public Properties
        public string CommandText
        {
            get { return _commandText; }
            set { _commandText = value; }
        }

        public int CommandTimeout
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
            set { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        public CommandType CommandType
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
            set { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        public IDbConnection Connection
        {
            get { return _connection; }
            set { _connection = (XmlConnection)value; }
        }

        public IDataParameterCollection Parameters
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        public IDbTransaction Transaction
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
            set { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        public UpdateRowSource UpdatedRowSource
        {
            get { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
            set { throw new InvalidOperationException("XmlClient Provider does not support this property"); }
        }

        // Public Methods
        public void Cancel()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public IDbDataParameter CreateParameter()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public int ExecuteNonQuery()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public IDataReader ExecuteReader()
        {
            return null;
        }

        public IDataReader ExecuteReader(CommandBehavior behavior)
        {
            return null;
        }

        public object ExecuteScalar()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public void Prepare()
        {
            //throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        ////////////////////
        // ICloneable
        ////////////////////
        public object Clone()
        {
            return null;
        }

        ////////////////////
        // Internal Data Members
        ////////////////////
        internal string _commandText = "";
        internal XmlConnection _connection = null;
    }
}