﻿using System;
using System.ComponentModel;
using System.Data;
using System.Xml;

namespace System.Data.XmlClient
{

    public class XmlConnection : Component, IDbConnection, ICloneable
    {
        // Constructors
        public XmlConnection()
        {
        }

        public XmlConnection(string connectionString)
        {
            _connString = connectionString;
        }

        ////////////////////
        // IDbConnection
        ////////////////////

        // Public Properties
        public string ConnectionString
        {
            get { return _connString; }
            set { _connString = value; }
        }

        public int ConnectionTimeout
        {
            get
            {
                throw new InvalidOperationException("XmlClient Provider does not support this function");
            }
        }
        public string Database
        {
            get
            {
                throw new InvalidOperationException("XmlClient Provider does not support this function");
            }
        }
        public ConnectionState State
        {
            get { return _connState; }
        }

        // Public Methods
        public IDbTransaction BeginTransaction()
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public IDbTransaction BeginTransaction(IsolationLevel lvl)
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public void ChangeDatabase(string databaseName)
        {
            throw new InvalidOperationException("XmlClient Provider does not support this function");
        }

        public void Close()
        {
            _doc.RemoveAll();
            _connState = ConnectionState.Closed;
        }

        public IDbCommand CreateCommand()
        {
            return new XmlCommand("", this);
        }

        public void Open()
        {
            _doc.Load(_connString);
            _connState = ConnectionState.Open;
        }

        ////////////////////
        // ICloneable
        ////////////////////
        public object Clone()
        {
            return null;
        }

        ////////////////////
        // Internal Data Members
        ////////////////////
        internal ConnectionState _connState = ConnectionState.Closed;
        internal string _connString = "";
        internal XmlDocument _doc = new XmlDocument();

    }
}
