/*!
 * MultiUpload for xheditor
 * @requires xhEditor
 * 
 * @author Yanis.Wang<yanis.wang@gmail.com>
 * @site http://xheditor.com/
 * @licence LGPL(http://www.opensource.org/licenses/lgpl-license.php)
 * 
 * @Version: 0.9.2 (build 100505)
 */
var swfu,selQueue=[],selectID,arrMsg=[],allSize=0,uploadSize=0,truedelete=0,ui=0;
function removeFile()
{
	var file;
	if(!selectID)return;
	if($('#'+selectID+'_url').text()!=''){
		truedelete += 1;
        swfu.setFileUploadLimit(swfu.settings.file_upload_limit+1);
	}
	for(var i in selQueue)
	{
		file=selQueue[i];
		if(file.id==selectID)
		{
			selQueue.splice(i,1);
			allSize-=file.size;
			swfu.cancelUpload(file.id);
			$('#'+file.id).remove();
			selectID=null;
			break;
		}
	}
	if(selQueue.length>=6)  window.parent.autosize(-26);
	$('#btnClear').hide();
}
function startUploadFiles()
{
	if(swfu.getStats().files_queued>0)
	{
		swfu.startUpload();
	}
	else alert('上传前请先添加文件');
}
function setFileState(fileid,txt)
{
	if(txt!='上传成功'){
		$('#'+fileid+'_state').css({"color":"red"});
	}
	$('#'+fileid+'_state').text(txt);
}
function setFileNew(fileid,txt)
{
	$('#'+fileid+'_url').text(txt);
}
function fileQueued(file)//队列添加成功
{
	for(var i in selQueue)if(selQueue[i].name==file.name){swfu.cancelUpload(file.id);return false;}//防止同名文件重复添加
	if(selQueue.length>=6)  window.parent.autosize(26);
	if(selQueue.length==0)$('#controlBtns').show();
	selQueue.push(file);
	allSize+=file.size;
	var fileurl = '<span style="display:none" id="'+file.id+'_url"></span>';
	$('#listBody').append('<tr id="'+file.id+'"><td>'+fileurl+file.name+'</td><td>'+formatBytes(file.size)+'</td><td id="'+file.id+'_state">等待上传</td></tr>');
	$('#'+file.id).hover(function(){$(this).addClass('hover');},function(){$(this).removeClass('hover');})
	.click(function(){selectID=file.id;$('#listBody tr').removeClass('select');$(this).removeClass('hover').addClass('select');$('#btnClear').show();})
}



function fileQueueError(file, errorCode, message)//队列添加失败
{
	var errorName='';
	switch (errorCode)
	{
		case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
			errorName = "对不起，您还可以上传 "+(this.settings.file_upload_limit-truedelete)+" 个文件";
			break;
		case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
			errorName = "选择的文件超过了当前大小限制："+this.settings.file_size_limit;
			break;
		case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
			errorName = "零大小文件";
			break;
		case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
			errorName = "文件扩展名必需为："+this.settings.file_types_description+" ("+this.settings.file_types+")";
			break;
		default:
			errorName = "未知错误";
			break;
	}
	alert(errorName);
}
function uploadStart(file)//单文件上传开始
{
	$('#'+file.id+'_state').text('');
    $('#'+file.id+'_state').append('<div class="progressBar" id="'+file.id+'_bar"><span>0%</span><div class="progress" style="width:1px;" id="'+file.id+'_pro"></div></div>');
}
function uploadProgress(file, bytesLoaded, bytesTotal)//单文件上传进度
{
	var filepercent=Math.ceil((bytesLoaded)/file.size*100);
	$('#'+file.id+'_bar span').text(filepercent+'% ('+formatBytes(bytesLoaded)+' / '+formatBytes(file.size)+')');
    $('#'+file.id+'_bar div').css('width',filepercent+'%');
}
function uploadSuccess(file, serverData){//单文件上传成功
	var data=Object;
	ui++;
	try{eval("data=" + serverData);}catch(ex){};
	if(data.error==0){
  	   uploadSize+=file.size;
	   setFileNew(file.id,data.url);
	   addItem(data.url,data.trueurl);
	   window.parent.ploadNum(true);
	}else{
	   alert(data.message);
	}
}
function uploadError(file, errorCode, message)//单文件上传错误
{
	setFileState(file.id,'上传失败！');
}
function uploadComplete(file)//文件上传周期结束
{
	if(swfu.getStats().files_queued>0)swfu.startUpload();
	else uploadAllComplete();
}
function uploadAllComplete(){
   alert('上传完毕');
   self.parent.tb_remove();
}
function formatBytes(bytes){
	var s = ['Byte', 'KB', 'MB', 'GB', 'TB', 'PB'];
	var e = Math.floor(Math.log(bytes)/Math.log(1024));
	return (bytes/Math.pow(1024, Math.floor(e))).toFixed(2)+" "+s[e];
}
function addItem(url,path){
	$('#uploadPic',window.parent.document).animate({ height: "115px" }, 300);
	var cover;
	if($('#uploadlist',window.parent.document).html().trim()==''){
		cover = '封面';
	}else{
	   	cover = "&nbsp;";
	}
	var div = "<li>";
	div += '<div class="displayimg"><img src="'+url+'" /></div>';
	div += '<a class="previous" href="javascript:void(0);"></a>';          
    div += '<span class="front-cover">'+cover+'</span>';
    div += '<a class="next" href="javascript:void(0);"></a>';
    div += '<a class="delete" href="javascript:void(0);"></a>';
	div += '<input type="hidden" name="uploadlist[]" value="'+url+'" />';
    div += '</li>';
    $('#uploadlist',window.parent.document).append(div);
}