<?php
class user_class{
	public $sessionid = "uid";
	public $sessionshell = "shell";
	public $cookie = true;//是否使用cookie方式登录
	private $mysql;
	private $sessionadmin = 'adminid';
	public $repass = "repass";	
    function __construct($module){
        $this->mysql = $module->mysql;
		$this->module = $module;
		$this->purviews = $this->module->purviews;
		$this->purview = $this->module->module.'_'.$this->module->action;
		$this->module->sessionadmin = $this->sessionadmin();
    } 
	public function checkuser() {
	    $uid = $this->cookie ? $_COOKIE[$this->sessionid] : $_SESSION[$this->sessionid];
		$shell = $this->cookie ? $_COOKIE[$this->sessionshell] : $_SESSION[$this->sessionshell];
		$mustlogin = $this->purviews[$this->purview][1];//该页面是否需要登录
        $admin = strstr($this->purview,'admin');//该页面是否为后台页面
		if($uid==''||$shell==''){//如果没有登录
		   if($mustlogin){
			  if($admin){
				 $this->dropuser();
		         location('admin_login');
			  }else{
		         $this->logout('member_login','请登陆后进行操作');
			  }
		   }
		   return false;
		}else{
		  $user = is_array($row = $this->sql($uid));//会员是否存在
		  $login = $user ? $shell == md5($row[username] . $row[password] . $row[salt]) : false;//是否有效会员
		  if(!$login){//不是有效会员的情况
		      if($mustlogin){
			     if($admin){
				    $this->dropuser();
		            location('admin_login');
			     }else{
		            $this->logout('member_login','请登陆后进行操作');
			     }
			  }
			  return false;  
		  }else{//重新更新登录时间
			  $this->keep($uid,$shell);
			  if($admin&&$this->sessionadmin()) $this->keepadmin($uid);
			  return $row;
		  }
		}
	}	
	
	function purview(){
	    $purviews = explode(',',$this->module->member[purviews]);
		if($this->module->member['purviews']=='adminall'||in_array($this->purview,$purviews)||!array_key_exists($this->purview,$this->purviews)){
		   return true;
		}else{
		   $this->module->message('go_back','对不起，您没有权限');
		   return false;
		}
	}
	
	public function login($username,$password,$seccode,$admin=false) {
		$username = str_replace(" ", "", $username);
		$password = str_replace(" ", "", $password);
		$seccode = str_replace(" ", "", $seccode);
		if($username=='') $this->module->message('go_back','您还没有输入用户名');
		if($password=='') $this->module->message('go_back','请输入您的登陆密码');
		if(config::get("mustcode")&&$seccode=='') $this->module->message('go_back','对不起，验证码不能为空');
		if(config::get("mustcode")&&$seccode!=$_SESSION['seccode']){
					 if($this->module->action=='ajaxlogin'){
			           $this->module->javascript('index','对不起，验证码不正确');	 
					 }else{
			           $this->module->message('go_back','对不起，验证码不正确');	 
					 }	
			  	
		}
		if(!is_array($row = $this->sql($username,'username'))){
					 if($this->module->action=='ajaxlogin'){
			           $this->module->javascript('index','对不起，该用户不存在');	 
					 }else{
			           $this->module->message('go_back','对不起，该用户不存在');	 
					 }	
			  	
		}
		if(!$row['status']) $this->logout('go_back','该用户已经被锁定');  
		if($this->password($password,$row[salt]) == $row[password]){//密码是否正确
		   $this->keep($row[uid],md5($row[username].$row[password].$row[salt])); 
		   $this->logininfo($row);
		   if($admin){
		      if(!$row['isadmin']) $this->module->message('index_main','非管理员不能进入后台');
			  $this->adminlogin($row['uid']);
		   }else{
					 if($this->module->action=='ajaxlogin'){
			           $this->module->javascript('member','恭喜您，用户登陆成功');	 
					 }else{
			           $this->module->message('member','恭喜您，用户登陆成功');	 
					 }	
		   } 
		}else{
		   if($admin){
			  $this->dropadmin();
			  $this->module->message('go_back','对不起，您的密码有误');
		   }else{
			  $this->dropuser();
					 if($this->module->action=='ajaxlogin'){
			           $this->module->javascript('index','对不起，您的密码有误');	 
					 }else{
			           $this->module->message('go_back','对不起，您的密码有误');	 
					 }	
			  
		   }
	    }   	   			

	}
	
	function logininfo($row){
	    $arr['lastip'] = getip();
		$arr['lasttime'] = time();
		$arr['loginnum'] = $row['loginnum']+1;
		$this->update($arr,$row['uid']);
	}
	
	
	function loginlog($arr){
		$arr['type'] = 0;
		$arr['uid'] = $arr['uid'];
		$arr['addtime'] = time();
        $this->mysql->insert("{$this->module->pre}log",$arr);
	}
	
	function update($arr,$uid){
		if($arr['password']){
		   $salt = $this->mysql->value("{$this->module->pre}user",'salt',"uid ='$uid'");
		   $arr['password'] = $this->password($arr['password'],$salt);
		}else{
		   unset($arr['password']);	
		}
		$this->mysql->update("{$this->module->pre}user",$arr,"uid ='$uid'");
	}
	
	function insert($arr){
		$pwd = $arr['password'];
		$arr['salt'] = $this->salt();
        $arr['password'] = $this->password($arr['password'],$arr['salt']);
		$arr['regtime'] = time();
		$arr['regip'] = getip();
		$arr['groupid'] = $arr['groupid'] ? $arr['groupid'] : '2';
		//$arr['userfen'] = config::get("regjifen");
        $this->mysql->insert("{$this->module->pre}user",$arr);
	}
	
	function isrepass(){
		$repass = $this->cookie ? $_COOKIE[$this->repass] : $_SESSION[$this->repass];
		$uid = $this->cookie ? $_COOKIE[$this->sessionid] : $_SESSION[$this->sessionid];
		return $repass!=''&&$uid!=''&&$repass==$uid;
	}
	public function relogin($password){  
     if($password=='') $this->module->message('go_back','请输入您的安全密码','0');
	 if($this->password($password,$this->module->member['salt']) == $this->module->member['repass']){
	   $this->keeprepass($this->module->member['uid']);
	 }else{
	   $this->module->message('go_back','您输入的安全密码有误','0');	
	 }		
	}
	
	private function keeprepass($uid){
       return $this->cookie ? $this->putcookie($this->repass,$uid,1200) : $_SESSION[$this->repass] = $uid;
	}
	
	
	function checkusername($username){
         return is_array($this->sql($username,'username'));
	}
	
	function checkemail($email){
         return is_array($this->sql($email,'email'));
	}
	
	function logout($urlkey,$message) {
	    $this->dropuser();
		$this->module->message($urlkey,$message);
	}	
	
	function admin(){
		$module = $this->module->module;
		$action = $this->module->action;
		if($module=='admin'&&$action!='login'&&$action!='logout'&&$action!='message'&&!$this->sessionadmin()){
		   $this->dropadmin();
		   location('admin_login');
        }
	}
	
	function sessionadmin(){
		$sessionadmin = $this->cookie ? $_COOKIE[$this->sessionadmin] : $_SESSION[$this->sessionadmin];
		$uid = $this->cookie ? $_COOKIE[$this->sessionid] : $_SESSION[$this->sessionid];
		return $sessionadmin!=''&&$uid!=''&&$sessionadmin==$uid;
	}
	
	function adminlogin($uid){
        $this->keepadmin($uid); 
	    location('admin');
	}
	
	function adminlogout($urlkey) {		
	   $this->dropadmin();
	   location($urlkey);
	}	
	
	public function sql($val,$fields='uid'){
	   $pre = config::get("tablepre");
	   $row = $this->mysql->select_one("select * from {$this->module->pre}user where {$fields}='{$val}'");
	   if(is_array($row)){
		  $usergroup = $this->mysql->select_one("select * from {$this->module->pre}usergroup where groupid='{$row['groupid']}'");
		  $row['groupname'] = $usergroup['groupname'];
		  $row['purviews'] = $usergroup['purviews'];
		  $row['isadmin'] = $usergroup['isadmin'];
	   }
	   return $row;
	}
	
	function getval($fields,$uid){
         return $this->mysql->value("{$this->module->pre}user",$fields,"uid ='$uid'");;
	}	
	
	private function keepadmin($uid){
        return $this->cookie ? $this->putcookie($this->sessionadmin,$uid,1200) : $_SESSION[$this->sessionadmin] = $uid;
	}
	private function keep($uid,$shell){
		if($this->cookie){
		   $this->putcookie($this->sessionid,$uid);
		   $this->putcookie($this->sessionshell,$shell);
		}else{
		   $_SESSION[$this->sessionid] = $uid;
		   $_SESSION[$this->sessionshell] = $shell;			
		}
	}
	private function dropadmin(){
	   $this->dropcookie($this->sessionadmin);
	   $_SESSION[$this->sessionadmin] = "";			
	}
	private function dropuser(){
  	   $this->dropcookie($this->sessionid);
	   $this->dropcookie($this->sessionshell);
	   $_SESSION[$this->sessionid] = "";
	   $_SESSION[$this->sessionshell] = "";	
	   $this->dropadmin();
	}

	//写入cookie
    public function putcookie($key,$value,$keeptime=0){
		$keeptime = $keeptime==0 ? 60*60 : $keeptime;
	    setcookie($key,$value,time()+$keeptime,config::get('siteurl'));
    }
	
	//销毁cookie
    public function dropcookie($key){
	    setcookie($key,"",time()-1,config::get('siteurl'));
    }
	
	//密码加密
	public function password($password,$salt) {
		return md5(md5($password).$salt);
	}

	//密码后缀
	public function salt() {
		return substr(uniqid(rand()), -6);
	}
}
?>