﻿var editor;
function EditorInit(inputId, type) {
    if (type) {
        editor = KindEditor.create('#' + inputId, {
			items : [
						'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',
						'removeformat', '|', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist',
						'insertunorderedlist', '|', 'emoticons', 'image'],
			filterMode: true,

			uploadJson: '/inc/upload.ashx',
			afterFocus: function () { $('#' + inputId).focus(); },
			afterBlur: function () { $('#' + inputId).blur(); },
			afterUpload: function (url) {
			    Thumb(url);
			}
        });
    }
    else {
        editor = KindEditor.create('#' + inputId, {
            filterMode: true,
            //allowImageUpload: false,
            //allowFlashUpload: false,
            //allowMediaUpload: false,
            //allowFileManager : true,
            //fileManagerJson : sitePath + 'inc/file_manager_json.ashx',
            uploadJson: '/inc/upload.ashx',
            afterFocus: function () { $('#' + inputId).focus(); },
            afterBlur: function () { $('#' + inputId).blur(); },
            afterUpload: function (url) {
                Thumb(url);
            }

        });
    }
}


//回调图片
function Thumb(url) {
    if (url == '') { return; }
    url = url.replace("/uploads/?", "");
    $(".reviews").append('<li><img src="/uploads/?' + url + '_100x80" width="100" height="80"/><span><input name="thumb" type="radio" value="' + url + '" />选择</span></li>');
}

//回调图片
function Thumb2(url) {
    if (url == '') { return; }
    url = url.replace("/uploads/?", "");
    $(".reviews").append('<li><img src="/uploads/?' + url + '_100x80" width="100" height="80"/><span><input name="thumb" type="checkbox" value="' + url + '" />选择</span></li>');
}


function CheckEditor() {
    if (editor.isEmpty()) {
        return false;
    }
    else {
        return true;
    }
}

function CheckAll(ele) {
    $("input:checkbox[id$='" + ele + "']").prop("checked", $("#chkall").prop("checked"));
}

function CheckLen() {
    if ($(":checkbox[name*='chkBox']:checked").length == 0) {
        alert('请勾选要处理的项目');
        return false;
    }
    return true;
}

$(function () {
    $("li.edit a,li.del a").click(function () {
        return CheckLen();
    });
});

var dialog;
//open dialog
function KyoDialog(tit, content) {
    dialog = art.dialog({
        id: "d",
        title: tit,
        content: content,
        padding: 0,
        resize: false,
        lock: true,
        background: '#6ccff7', // 背景色
        opacity: 0.17	// 透明度
    });
}
function KyoWin(tit, url) {
    art.dialog.open(url, {
        id: "e",
        title: tit,
        padding: 0,
        resize: false,
        lock: true,
        background: '#6ccff7', // 背景色
        opacity: 0.17	// 透明度
    });
}

function ShowAlert(msg, ico) {
    var icoStr;
    switch (ico) {
        case 1:
            icoStr = "error";
            break;
        case 2:
            icoStr = "warning";
            break;
        case 3:
            icoStr = "question";
            break;
        default:
            icoStr = "succeed";
            break;
    }
    art.dialog({
        id: 'testID',
        time: 1,
        icon: icoStr,
        content: msg,
        lock: true,
        background: '#6ccff7',
        opacity: 0.17
    });
}



function changeCheckBox(id) {
    var obj = $("#ck_" + id)[0];
    var objo = $("#" + id)[0];
    if (objo.checked) {
        obj.className = "checkbox";
        objo.checked = false;
    }
    else {
        obj.className = "checkbox checked";
        objo.checked = true;
    }
}


//图片上传 file--文件名;obj--记录表单
function UpReturn(file, obj) {
    DelPic();
    if (file == '') { return; }
    $("#" + obj).val(file);
    $("#" + obj + "_Preview").html('<ul class="reviews"><li><img src="/uploads/?' + file + '_100x80.jpg" width="100" height="80"/><span><a href="javascript:;" onClick="DelPic(\'' + obj + '\');">删除</a></span></li></ul>');
}
function DelPic(obj) {
    $("#" + obj + "_Preview").html('');
    $("#" + obj).val('');
}