<?php

namespace addons_interface;

interface PayAddonsInterface
{
    /**
     * 使用支付类插件接口须知
     *
     * 所有支付类插件如需加入自动识别支付功能，必须实现下面的钩子，但不一定必须使用本接口
     *
     * 实现pay_addons用于使插件被自动识别功能识别
     *
     * 建议插件在支付回调地址中填写插件内的地址，以便支付完成后执行回调与验签工作
     *
     * 建议插件在添加进自己的订单列表中时，写入调起支付插件的插件名与回调钩子，以便完成支付回调后继续完成业务回调
     */

    /**
     * 自动识别流程：
     *
     * 1。支付插件 按要求实现pay_addons钩子
     * 2。业务插件 在打开设置页面时，若需使用自动识别支付，应定义一个设置name为pay_type，content为空数组，type为checkbox
     * 3。业务插件 如需限定使用插件的返回类型，应在插件内设置公用变量$use_pay_result，如需设置只使用二维码支付插件
     *
     *   public $use_pay_result = [
     *       'qr',
     *   ];
     *
     * 现有的类型为qr二维码，url跳转链接
     * 若不设置use_pay_result变量，则为全部支付结果都能接受，若变量为空数组，则为所有类型都不接受
     * 具体参数应与 支付插件 pay_addons实现中的pay_result参数一致
     */

    /**
     * 下单流程如下：
     *
     * 1。业务插件 在下单页面使用辅助函数 pay_addons()获取支付插件信息，插件信息如下
     *
     *   [
     *       "alipayface-0" => "支付宝当面付"
     *   ]
     *
     * 2。业务插件 发起统一下单请求，调用 goalong_pay($pay_type,$data)支付函数
     *  $paytyoe即为"alipayface-0"，$data为下单参数
     * 3。业务插件 调用支付函数时，应传入相应支付参数，以及addons（业务插件名），addons_notify（业务插件中处理回调的钩子名）
     * 4。支付插件 发起统一下单，并返回结果。若下单成功，支付插件 应返回结果类型（应同pay_addons中的pay_result）
     * 5。业务插件 收到下单结果后，继续自己的业务流程
     */

    /**
     * 回调流程如下：
     *
     * 1。支付插件 在发起下单时，应填写自己插件的地址作为回调地址
     * 2。支付插件 在收到回调后，应执行验签与自己的回调流程
     * 3。支付插件 在回调验证完成后，根据调起支付时传入的业务插件名addons与业务插件回调钩子addons_notify，使用业务插件的回调钩子
     * 4。支付插件 在使用业务插件回调钩子时，应统一参数如下
     *
     *  此处以支付宝回调为例
     *   return [
     *       'code' => 0, //此处填写0
     *       'status' => 'success', //此处填写success
     *       'order_params' => [ //订单参数
     *           'out_trade_no' => '37386521568423', //订单号
     *           'total_amount' => '0.01', //订单金额，单位：元
     *           'pay_time' => '2021-05-01 16:02:04', //支付时间，如 2021-05-01 16:02:04
     *       ],
     *       'notify_params' => $params,//回调时的所有参数，以便业务插件使用，应为数组
     *       'hook' => 'alipayface',//支付插件插件名
     *   ];
     *
     * 5。业务插件收到回调后，执行自己的业务逻辑
     */

    /**
     * 支付插件信息返回方法
     *
     * 应返回一个二维数组，一维数组中的每一个参数都应对应插件内的一个支付方式
     *
     *   return [
     *       [
     *           'name' => 'alipayface',//插件名
     *           'pay' => 'pay',//支付钩子名称
     *           'title' => '支付宝当面付',//显示名称
     *           'pay_scene' => [//允许使用环境，any所有，pc电脑，mobile手机
     *               'pc'
     *           ],//可用环境
     *           'pay_result' => 'qr',//支付结果类型，qr二维码链接，url跳转链接
     *       ]
     *   ];
     *
     * 注：因为自动识别功能中，有使用内置函数处理参数，请在参数name和pay中不要出现短横杠符号：-
     *
     * @return array
     */
    public function pay_addons(): array;

    /**
     * 以下为pay_addons()示例
     */
    /*public function pay_addons(): array
    {
        $info = $this->getInfo();
        if ($info['state'] != 1) return [];
        $config = $this->getConfig(0, 1);
        if ($config['status'] != 1) return [];

        return [
            [
                'name' => $this->getName(),//插件名
                'pay' => 'pay',//支付钩子名称
                'title' => '支付宝当面付',//显示名称
                'pay_scene' => [//允许使用环境，pc电脑，mobile手机
                    'any'
                ],//可用环境
                'pay_result' => 'qr',//支付结果类型，qr二维码链接，url跳转链接
            ]
        ];
    }*/
}