<?php

namespace addons_interface;

interface SmsAddonsInterface
{
    /**
     * 使用短信类插件接口须知
     *
     * 所有短信类插件如需加入自动识别短信功能，必须实现下面的钩子，但不必使用本接口
     *
     * 实现sms_addons用于使插件被自动识别功能识别
     */

    /**
     * 短信插件信息返回方法
     *
     * 应返回一个二维数组，一维数组中的每一个参数都应对应插件内的一个发信方式
     *
     *   return [
     *       [
     *           'name' => 'sms',//插件名
     *           'send' => 'send_sms',//发送钩子名称
     *           'title' => '短信宝',//显示名称
     *       ]
     *   ];
     *
     * 注：因为自动识别功能中，有使用内置函数处理参数，请在参数name和send中不要出现短横杠符号：-
     *
     * @return array
     */
    public function sms_addons(): array;
}